/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.util;

import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.time.FastDateFormat;
import org.jasig.portlet.calendar.CalendarEvent;

public class AllDayUtil {
    private static final String TIME_FORMAT = "Hms";
    private static final String EXPECTED_TIME = "000";
    private static final int MIN_DAY = 79200000;
    private static final int MAX_DAY = 93600000;
    private static ConcurrentHashMap<TimeZone, FastDateFormat> dateFormatCache = new ConcurrentHashMap();

    public static boolean isAllDayEvent(CalendarEvent event, TimeZone timezone) {
        FastDateFormat df;
        if (dateFormatCache.contains(timezone)) {
            df = (FastDateFormat)dateFormatCache.get(timezone);
        } else {
            df = FastDateFormat.getInstance((String)TIME_FORMAT, (TimeZone)timezone);
            dateFormatCache.put(timezone, df);
        }
        String start = df.format((Date)event.getStartDate().getDate());
        if (!EXPECTED_TIME.equals(start)) {
            return false;
        }
        if (event.getEndDate() == null) {
            return false;
        }
        String end = df.format((Date)event.getEndDate().getDate());
        if (!EXPECTED_TIME.equals(end)) {
            return false;
        }
        long duration = event.getEndDate().getDate().getTime() - event.getStartDate().getDate().getTime();
        return duration >= 79200000L && duration <= 93600000L;
    }
}

