/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.adapter;

import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import javax.portlet.PortletRequest;
import net.fortuna.ical4j.model.DefaultTimeZoneRegistryFactory;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.component.VEvent;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.calendar.CalendarConfiguration;
import org.jasig.portlet.calendar.adapter.CalendarEventSet;
import org.jasig.portlet.calendar.adapter.ICalendarAdapter;
import org.jasig.portlet.calendar.mvc.JsonCalendarEvent;
import org.springframework.beans.factory.annotation.Required;

public class CalendarEventsDao {
    protected final Log log = LogFactory.getLog(this.getClass());
    private Cache cache;

    @Required
    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public Set<JsonCalendarEvent> getEvents(ICalendarAdapter adapter, CalendarConfiguration calendar, Period period, PortletRequest request, TimeZone tz) {
        HashSet<JsonCalendarEvent> jsonEvents;
        CalendarEventSet eventSet = adapter.getEvents(calendar, period, request);
        DefaultTimeZoneRegistryFactory tzFactory = new DefaultTimeZoneRegistryFactory();
        TimeZoneRegistry tzRegistry = tzFactory.createRegistry();
        String tzKey = eventSet.getKey().concat(tz.getID());
        Element cachedElement = this.cache.get((Serializable)((Object)eventSet.getKey()));
        if (cachedElement == null) {
            jsonEvents = new HashSet();
            Set<VEvent> events = eventSet.getEvents();
            for (VEvent event : events) {
                try {
                    jsonEvents.addAll(this.getStuff(event, tz, tzRegistry, period));
                }
                catch (ParseException e) {
                    this.log.error((Object)"Exception parsing event", (Throwable)e);
                }
                catch (IOException e) {
                    this.log.error((Object)"Exception parsing event", (Throwable)e);
                }
                catch (URISyntaxException e) {
                    this.log.error((Object)"Exception parsing event", (Throwable)e);
                }
            }
            cachedElement = new Element((Object)tzKey, (Object)eventSet);
            this.cache.put(cachedElement);
        } else {
            jsonEvents = (Set)((Object)cachedElement.getValue());
        }
        return jsonEvents;
    }

    protected Set<JsonCalendarEvent> getStuff(VEvent e, TimeZone tz, TimeZoneRegistry tzRegistry, Period period) throws ParseException, IOException, URISyntaxException {
        VEvent event = (VEvent)e.copy();
        if (event.getStartDate().getTimeZone() == null && !event.getStartDate().isUtc()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Identified event " + event.getSummary() + " as a floating event"));
            }
            int offset = tz.getOffset(event.getStartDate().getDate().getTime());
            event.getStartDate().getDate().setTime(event.getStartDate().getDate().getTime() - (long)offset);
            if (event.getEndDate() != null) {
                event.getEndDate().getDate().setTime(event.getEndDate().getDate().getTime() - (long)offset);
            }
        } else if (event.getStartDate().isUtc()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Setting time zone to UTC for  event " + event.getSummary()));
            }
            event.getStartDate().setTimeZone(tzRegistry.getTimeZone("UTC"));
            if (event.getEndDate() != null) {
                event.getEndDate().setTimeZone(tzRegistry.getTimeZone("UTC"));
            }
        }
        Set<JsonCalendarEvent> events = this.getJsonEvents(event, period, tz);
        return events;
    }

    protected Set<JsonCalendarEvent> getJsonEvents(VEvent event, Period period, TimeZone tz) throws IOException, URISyntaxException, ParseException {
        Calendar dayStart = Calendar.getInstance(tz);
        dayStart.setTime((Date)event.getStartDate().getDate());
        dayStart.set(10, 0);
        dayStart.set(12, 0);
        dayStart.set(13, 0);
        dayStart.set(14, 1);
        Calendar dayEnd = (Calendar)dayStart.clone();
        dayEnd.add(5, 1);
        Calendar eventEnd = Calendar.getInstance(tz);
        if (event.getEndDate() != null) {
            eventEnd.setTime((Date)event.getEndDate().getDate());
        } else {
            eventEnd.setTime((Date)event.getStartDate().getDate());
        }
        HashSet<JsonCalendarEvent> events = new HashSet<JsonCalendarEvent>();
        do {
            JsonCalendarEvent json;
            if (period.includes((json = new JsonCalendarEvent(event, dayStart.getTime(), tz)).getDayStart(), 1) || period.includes(json.getDayEnd(), 2)) {
                events.add(json);
            }
            dayStart.add(5, 1);
            dayEnd.add(5, 1);
        } while (dayStart.before(eventEnd));
        return events;
    }
}

