/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.adapter.exchange;

import java.io.IOException;
import java.net.URI;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.jasig.portlet.calendar.adapter.exchange.CommonsHttpConnection;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.ws.transport.WebServiceConnection;
import org.springframework.ws.transport.http.AbstractHttpWebServiceMessageSender;

public class ExchangeHttpWebServiceMessageSender
extends AbstractHttpWebServiceMessageSender
implements InitializingBean,
DisposableBean {
    protected static final String EXCHANGE_CREDENTIALS_ATTRIBUTE = "exchangeCredentials";
    protected static final String EXCHANGE_CLIENT_ATTRIBUTE = "exchangeHttpClient";
    private int connectionTimeout = 60000;
    private int readTimeout = 60000;
    private int maxConnections = 200;
    private MultiThreadedHttpConnectionManager connectionManager;

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        if (this.connectionManager != null) {
            this.connectionManager.getParams().setConnectionTimeout(connectionTimeout);
        }
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        if (this.connectionManager != null) {
            this.connectionManager.getParams().setSoTimeout(readTimeout);
        }
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
        if (this.connectionManager != null) {
            this.connectionManager.getParams().setDefaultMaxConnectionsPerHost(maxConnections);
            this.connectionManager.getParams().setMaxTotalConnections(maxConnections);
        }
    }

    public WebServiceConnection createConnection(URI uri) throws IOException {
        PostMethod postMethod = new PostMethod(uri.toString());
        if (this.isAcceptGzipEncoding()) {
            postMethod.addRequestHeader("Accept-Encoding", "gzip");
        }
        HttpClient client = this.getClient();
        return new CommonsHttpConnection(client, postMethod);
    }

    protected HttpClient getClient() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        HttpClient client = (HttpClient)requestAttributes.getAttribute(EXCHANGE_CLIENT_ATTRIBUTE, 1);
        if (client == null) {
            client = new HttpClient((HttpConnectionManager)this.connectionManager);
            Credentials credentials = this.getCredentials();
            client.getState().setCredentials(AuthScope.ANY, credentials);
            client.getParams().setAuthenticationPreemptive(true);
            requestAttributes.setAttribute(EXCHANGE_CLIENT_ATTRIBUTE, (Object)client, 1);
        }
        return client;
    }

    protected Credentials getCredentials() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        Credentials credentials = (Credentials)requestAttributes.getAttribute(EXCHANGE_CREDENTIALS_ATTRIBUTE, 1);
        return credentials;
    }

    public void afterPropertiesSet() throws Exception {
        this.connectionManager = new MultiThreadedHttpConnectionManager();
        this.connectionManager.getParams().setConnectionTimeout(this.connectionTimeout);
        this.connectionManager.getParams().setSoTimeout(this.readTimeout);
        this.connectionManager.getParams().setDefaultMaxConnectionsPerHost(this.maxConnections);
        this.connectionManager.getParams().setMaxTotalConnections(this.maxConnections);
    }

    public void destroy() throws Exception {
        this.connectionManager.shutdown();
    }
}

