/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.processor;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.CalendarParser;
import net.fortuna.ical4j.data.CalendarParserImpl;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.ExDate;
import net.fortuna.ical4j.model.property.ExRule;
import net.fortuna.ical4j.model.property.RDate;
import net.fortuna.ical4j.model.property.RRule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.calendar.adapter.CalendarException;
import org.jasig.portlet.calendar.processor.IContentProcessor;

public class ICalendarContentProcessorImpl
implements IContentProcessor {
    protected final Log log = LogFactory.getLog(this.getClass());

    public Set<VEvent> getEvents(Long calendarId, Period period, InputStream in) {
        try {
            this.log.debug((Object)"begin getEvents");
            CalendarBuilder builder = new CalendarBuilder((CalendarParser)new CalendarParserImpl());
            Calendar calendar = builder.build(in);
            this.log.debug((Object)"calendar built");
            return this.convertCalendarToEvents(calendarId, calendar, period);
        }
        catch (IOException e) {
            this.log.error((Object)"IOException in getEvents", (Throwable)e);
            throw new CalendarException("caught IOException", (Throwable)e);
        }
        catch (ParserException e) {
            this.log.error((Object)"ParserException in getEvents", (Throwable)e);
            throw new CalendarException("caught ParserException", (Throwable)e);
        }
    }

    protected final Set<VEvent> convertCalendarToEvents(Long calendarId, Calendar calendar, Period period) throws CalendarException {
        HashSet<VEvent> events = new HashSet<VEvent>();
        if (calendar == null) {
            this.log.warn((Object)"calendar was empty, returning empty set");
            return Collections.emptySet();
        }
        for (Component component : calendar.getComponents()) {
            if (!component.getName().equals("VEVENT")) continue;
            VEvent event = (VEvent)component;
            this.log.trace((Object)("processing event " + event.getSummary()));
            PeriodList periods = event.calculateRecurrenceSet(period);
            for (Period eventper : periods) {
                this.log.debug((Object)("Found time period staring at " + eventper.getStart().isUtc() + ", " + eventper.getStart().getTimeZone() + ", " + event.getStartDate().getTimeZone() + ", " + event.getStartDate().isUtc()));
                PropertyList props = event.getProperties();
                PropertyList newprops = new PropertyList();
                DtStart start = new DtStart();
                start.setDate((Date)eventper.getStart());
                start.setTimeZone(event.getStartDate().getTimeZone());
                start.setUtc(event.getStartDate().isUtc());
                newprops.add((Property)start);
                if (event.getEndDate() != null) {
                    DtEnd end = new DtEnd();
                    end.setTimeZone(event.getEndDate().getTimeZone());
                    end.setDate((Date)eventper.getEnd());
                    end.setUtc(event.getEndDate().isUtc());
                    newprops.add((Property)end);
                }
                for (Property prop : props) {
                    if (prop instanceof DtStart || prop instanceof DtEnd || prop instanceof Duration || prop instanceof RRule || prop instanceof RDate || prop instanceof ExRule || prop instanceof ExDate) continue;
                    newprops.add(prop);
                }
                VEvent newevent = new VEvent(newprops);
                events.add(newevent);
                this.log.trace((Object)("added event " + newevent));
            }
        }
        return events;
    }
}

