/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.adapter;

import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletRequest;
import net.fortuna.ical4j.model.component.VEvent;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.calendar.CalendarConfiguration;
import org.jasig.portlet.calendar.adapter.CalendarEventSet;
import org.jasig.portlet.calendar.adapter.ICalendarAdapter;
import org.jasig.portlet.calendar.mvc.CalendarDisplayEvent;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.springframework.beans.factory.annotation.Required;

public class CalendarEventsDao {
    protected final Log log = LogFactory.getLog(this.getClass());
    private Cache cache;
    private Map<String, DateTimeFormatter> dateFormatters = new ConcurrentHashMap<String, DateTimeFormatter>();
    private Map<String, DateTimeFormatter> timeFormatters = new ConcurrentHashMap<String, DateTimeFormatter>();

    @Required
    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public Set<CalendarDisplayEvent> getEvents(ICalendarAdapter adapter, CalendarConfiguration calendar, Interval interval, PortletRequest request, DateTimeZone tz) {
        CalendarEventSet eventSet = adapter.getEvents(calendar, interval, request);
        String tzKey = eventSet.getKey().concat(tz.getID());
        Element cachedElement = this.cache.get((Serializable)((Object)tzKey));
        if (cachedElement != null) {
            Set jsonEvents = (Set)((Object)cachedElement.getValue());
            return jsonEvents;
        }
        HashSet<CalendarDisplayEvent> displayEvents = new HashSet<CalendarDisplayEvent>();
        for (VEvent event : eventSet.getEvents()) {
            try {
                displayEvents.addAll(this.getDisplayEvents(event, interval, tz));
            }
            catch (ParseException e) {
                this.log.error((Object)"Exception parsing event", (Throwable)e);
            }
            catch (IOException e) {
                this.log.error((Object)"Exception parsing event", (Throwable)e);
            }
            catch (URISyntaxException e) {
                this.log.error((Object)"Exception parsing event", (Throwable)e);
            }
        }
        cachedElement = new Element((Object)tzKey, displayEvents);
        this.cache.put(cachedElement);
        return displayEvents;
    }

    protected Set<CalendarDisplayEvent> getDisplayEvents(VEvent e, Interval interval, DateTimeZone timezone) throws IOException, URISyntaxException, ParseException {
        DateTime eventStart;
        VEvent event = (VEvent)e.copy();
        DateTime eventEnd = null;
        if (event.getStartDate().getTimeZone() == null && !event.getStartDate().isUtc()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Identified event " + event.getSummary() + " as a floating event"));
            }
            int offset = timezone.getOffset(event.getStartDate().getDate().getTime());
            eventStart = new DateTime(event.getStartDate().getDate().getTime() - (long)offset, timezone);
            if (event.getEndDate() != null) {
                eventEnd = new DateTime(event.getEndDate().getDate().getTime() - (long)offset, timezone);
            }
        } else {
            eventStart = new DateTime((Object)event.getStartDate().getDate(), timezone);
            if (event.getEndDate() != null) {
                eventEnd = new DateTime((Object)event.getEndDate().getDate(), timezone);
            }
        }
        if (eventEnd == null) {
            eventEnd = eventStart;
        }
        DateMidnight dayStart = new DateMidnight((Object)event.getStartDate().getDate(), timezone);
        DateMidnight dayEnd = dayStart.plusDays(1);
        DateTimeFormatter df = this.getDateFormatter(timezone);
        DateTimeFormatter tf = this.getTimeFormatter(timezone);
        HashSet<CalendarDisplayEvent> events = new HashSet<CalendarDisplayEvent>();
        do {
            Interval day = new Interval((ReadableInstant)dayStart, (ReadableInstant)dayEnd);
            Interval eventInterval = new Interval((ReadableInstant)eventStart, (ReadableInstant)eventEnd);
            CalendarDisplayEvent json = new CalendarDisplayEvent(event, eventInterval, day, df, tf);
            if (day.getStart().isEqual((ReadableInstant)eventStart)) {
                events.add(json);
            } else if (day.overlaps((ReadableInterval)eventInterval)) {
                events.add(json);
            }
            dayStart = dayStart.plusDays(1);
            dayEnd = dayEnd.plusDays(1);
        } while (dayStart.isBefore((ReadableInstant)eventEnd) && interval.contains((ReadableInstant)dayStart));
        return events;
    }

    protected DateTimeFormatter getDateFormatter(DateTimeZone timezone) {
        if (this.dateFormatters.containsKey(timezone.getID())) {
            return this.dateFormatters.get(timezone.getID());
        }
        DateTimeFormatter df = new DateTimeFormatterBuilder().appendDayOfWeekText().appendLiteral(" ").appendMonthOfYearText().appendLiteral(" ").appendDayOfMonth(1).toFormatter().withZone(timezone);
        this.dateFormatters.put(timezone.getID(), df);
        return df;
    }

    protected DateTimeFormatter getTimeFormatter(DateTimeZone timezone) {
        if (this.timeFormatters.containsKey(timezone.getID())) {
            return this.timeFormatters.get(timezone.getID());
        }
        DateTimeFormatter tf = new DateTimeFormatterBuilder().appendClockhourOfHalfday(1).appendLiteral(":").appendMinuteOfHour(2).appendLiteral(" ").appendHalfdayOfDayText().toFormatter().withZone(timezone);
        this.timeFormatters.put(timezone.getID(), tf);
        return tf;
    }
}

