/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.mvc.controller;

import java.io.Writer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Resource;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.model.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.calendar.CalendarConfiguration;
import org.jasig.portlet.calendar.CalendarConfigurationByNameComparator;
import org.jasig.portlet.calendar.CalendarSet;
import org.jasig.portlet.calendar.adapter.CalendarEventsDao;
import org.jasig.portlet.calendar.adapter.CalendarException;
import org.jasig.portlet.calendar.adapter.ICalendarAdapter;
import org.jasig.portlet.calendar.adapter.UserFeedbackCalendarException;
import org.jasig.portlet.calendar.dao.CalendarStore;
import org.jasig.portlet.calendar.dao.ICalendarSetDao;
import org.jasig.portlet.calendar.mvc.CalendarDisplayEvent;
import org.jasig.portlet.calendar.mvc.JsonCalendarEventWrapper;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class AjaxCalendarController
implements ApplicationContextAware {
    protected final Log log = LogFactory.getLog(this.getClass());
    private CalendarEventsDao calendarEventsDao;
    private ICalendarSetDao calendarSetDao;
    private CalendarStore calendarStore;
    private ApplicationContext applicationContext;

    @ResourceMapping
    public ModelAndView getEventList(ResourceRequest request, ResourceResponse response) throws Exception {
        String resourceId = request.getResourceID();
        String startDate = resourceId.split("-")[0];
        int days = Integer.parseInt(resourceId.split("-")[1]);
        long startTime = System.currentTimeMillis();
        PortletSession session = request.getPortletSession();
        HashMap<String, Object> model = new HashMap<String, Object>();
        CalendarSet set = this.calendarSetDao.getCalendarSet((PortletRequest)request);
        ArrayList calendars = new ArrayList();
        calendars.addAll(set.getConfigurations());
        Collections.sort(calendars, new CalendarConfigurationByNameComparator());
        HashMap hiddenCalendars = (HashMap)session.getAttribute("hiddenCalendars");
        Interval interval = this.getPeriod(request, startDate, days);
        String timezone = (String)session.getAttribute("timezone");
        DateTimeZone tz = DateTimeZone.forID((String)timezone);
        int index = 0;
        ArrayList<String> errors = new ArrayList<String>();
        TreeSet<JsonCalendarEventWrapper> events = new TreeSet<JsonCalendarEventWrapper>();
        for (CalendarConfiguration callisting : calendars) {
            if (hiddenCalendars.get(callisting.getId()) == null) {
                try {
                    ICalendarAdapter adapter = (ICalendarAdapter)this.applicationContext.getBean(callisting.getCalendarDefinition().getClassName());
                    Set calendarEvents = this.calendarEventsDao.getEvents(adapter, callisting, interval, (PortletRequest)request, tz);
                    for (CalendarDisplayEvent e : calendarEvents) {
                        events.add(new JsonCalendarEventWrapper(e, index));
                    }
                }
                catch (NoSuchBeanDefinitionException ex) {
                    this.log.error((Object)("Calendar class instance could not be found: " + ex.getMessage()));
                }
                catch (UserFeedbackCalendarException sce) {
                    StringBuilder msg = new StringBuilder();
                    msg.append(callisting.getCalendarDefinition().getName()).append(":  ").append(sce.getUserFeedback());
                    errors.add(msg.toString());
                }
                catch (Exception ex) {
                    this.log.warn((Object)"Unknown Error", (Throwable)ex);
                    errors.add("The calendar \"" + callisting.getCalendarDefinition().getName() + "\" is currently unavailable.");
                }
            }
            ++index;
        }
        DateTimeFormatter orderableDf = new DateTimeFormatterBuilder().appendYear(4, 4).appendLiteral("-").appendMonthOfYear(2).appendLiteral("-").appendDayOfMonth(2).toFormatter().withZone(tz);
        DateTimeFormatter displayDf = new DateTimeFormatterBuilder().appendDayOfWeekText().appendLiteral(" ").appendMonthOfYearText().appendLiteral(" ").appendDayOfMonth(1).toFormatter().withZone(tz);
        DateMidnight now = new DateMidnight(tz);
        String today = orderableDf.print((ReadableInstant)now);
        String tomorrow = orderableDf.print((ReadableInstant)now.plusDays(1));
        HashMap<String, String> dateDisplayNames = new HashMap<String, String>();
        LinkedHashMap eventsByDay = new LinkedHashMap();
        for (JsonCalendarEventWrapper event : events) {
            String day = orderableDf.print((ReadableInstant)event.getEvent().getDayStart());
            if (!eventsByDay.containsKey(day)) {
                eventsByDay.put(day, new ArrayList());
                if (today.equals(day)) {
                    dateDisplayNames.put(day, "Today");
                } else if (tomorrow.equals(day)) {
                    dateDisplayNames.put(day, "Tomorrow");
                } else {
                    dateDisplayNames.put(day, displayDf.print((ReadableInstant)event.getEvent().getDayStart()));
                }
            }
            ((List)eventsByDay.get(day)).add(event);
        }
        model.put("dateMap", eventsByDay);
        model.put("dateNames", dateDisplayNames);
        model.put("viewName", "jsonView");
        model.put("errors", errors);
        String etag = String.valueOf(((Object)model).hashCode());
        String requestEtag = request.getETag();
        if (request.getETag() != null && etag.equals(requestEtag)) {
            response.getCacheControl().setExpirationTime(1);
            response.getCacheControl().setUseCachedContent(true);
            return new ModelAndView("empty", Collections.emptyMap());
        }
        response.getCacheControl().setETag(etag);
        response.getCacheControl().setExpirationTime(1);
        long overallTime = System.currentTimeMillis() - startTime;
        this.log.debug((Object)("AjaxCalendarController took " + overallTime + " ms to produce JSON model"));
        return new ModelAndView("json", model);
    }

    @ResourceMapping(value="exportUserCalendar")
    public String exportCalendar(ResourceRequest request, ResourceResponse response, @RequestParam(value="configurationId") Long id) {
        CalendarConfiguration calendarConfig = this.calendarStore.getCalendarConfiguration(id);
        CalendarException exception = null;
        try {
            ICalendarAdapter adapter = (ICalendarAdapter)this.applicationContext.getBean(calendarConfig.getCalendarDefinition().getClassName());
            DateTime intervalStart = new DateTime().minusYears(1);
            DateTime intervalEnd = new DateTime().plusYears(1);
            Interval interval = new Interval((ReadableInstant)intervalStart, (ReadableInstant)intervalEnd);
            Calendar calendar = this.calendarEventsDao.getCalendar(adapter, calendarConfig, interval, (PortletRequest)request);
            response.setContentType("text/calendar");
            response.addProperty("Content-disposition", "attachment; filename=calendar.ics");
            CalendarOutputter calendarOut = new CalendarOutputter();
            calendarOut.output(calendar, (Writer)response.getWriter());
            response.flushBuffer();
            return null;
        }
        catch (NoSuchBeanDefinitionException ex) {
            exception = new CalendarException("Calendar adapter class instance could not be found", (Throwable)ex);
        }
        catch (Exception ex) {
            exception = new CalendarException("Error sending calendar " + calendarConfig.getCalendarDefinition().getName() + " to user for downloading", (Throwable)ex);
        }
        throw exception;
    }

    protected Interval getPeriod(ResourceRequest request, String startDate, int days) throws ParseException {
        PortletSession session = request.getPortletSession();
        String timezone = (String)session.getAttribute("timezone");
        DateTimeZone tz = DateTimeZone.forID((String)timezone);
        DateTimeFormatter df = new DateTimeFormatterBuilder().appendMonthOfYear(2).appendDayOfMonth(2).appendYear(4, 4).toFormatter().withZone(tz);
        DateMidnight start = new DateMidnight((Object)df.parseDateTime(startDate), tz);
        Interval interval = new Interval((ReadableInstant)start, (ReadableInstant)start.plusDays(days));
        this.log.debug((Object)("new interval: " + interval.toString()));
        session.setAttribute("startDate", (Object)start);
        session.setAttribute("days", (Object)days);
        return interval;
    }

    @Autowired(required=true)
    public void setCalendarEventsDao(CalendarEventsDao calendarEventsDao) {
        this.calendarEventsDao = calendarEventsDao;
    }

    @Autowired(required=true)
    public void setCalendarSetDao(ICalendarSetDao calendarSetDao) {
        this.calendarSetDao = calendarSetDao;
    }

    @Required
    @Resource(name="calendarStore")
    public void setCalendarStore(CalendarStore calendarStore) {
        this.calendarStore = calendarStore;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

