/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.url;

import javax.portlet.PortletRequest;
import org.jasig.portlet.calendar.CalendarConfiguration;
import org.jasig.portlet.calendar.adapter.CalendarException;
import org.jasig.portlet.calendar.url.IUrlCreator;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;

public class CalendarkeyUrlCreatorImpl
implements IUrlCreator {
    private DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern("yyyyMMdd").toFormatter();

    public String constructUrl(CalendarConfiguration calendarListing, Interval interval, PortletRequest request) {
        String username;
        String baseUrl = (String)calendarListing.getCalendarDefinition().getParameters().get("baseUrl");
        StringBuilder finalUrl = new StringBuilder();
        finalUrl.append(baseUrl);
        if (!baseUrl.endsWith("/")) {
            finalUrl.append("/");
        }
        if (null == (username = request.getRemoteUser()) || "".equals(username)) {
            throw new CalendarException("user not logged in");
        }
        finalUrl.append(username);
        finalUrl.append("/");
        finalUrl.append(this.formatter.print((ReadableInstant)interval.getStart()));
        finalUrl.append("/");
        finalUrl.append(this.formatter.print((ReadableInstant)interval.getEnd()));
        return finalUrl.toString();
    }
}

