/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.processor;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.CalendarParser;
import net.fortuna.ical4j.data.CalendarParserImpl;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.ExDate;
import net.fortuna.ical4j.model.property.ExRule;
import net.fortuna.ical4j.model.property.RDate;
import net.fortuna.ical4j.model.property.RRule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.calendar.adapter.CalendarException;
import org.jasig.portlet.calendar.processor.IContentProcessor;
import org.joda.time.Interval;

public class ICalendarContentProcessorImpl
implements IContentProcessor<Calendar> {
    protected final Log log = LogFactory.getLog(this.getClass());

    public Calendar getIntermediateCalendar(Interval interval, InputStream in) {
        try {
            this.log.debug((Object)"begin getEvents");
            CalendarBuilder builder = new CalendarBuilder((CalendarParser)new CalendarParserImpl());
            Calendar calendar = builder.build(in);
            this.log.debug((Object)"calendar built");
            return calendar;
        }
        catch (IOException e) {
            this.log.error((Object)"IOException in getEvents", (Throwable)e);
            throw new CalendarException("caught IOException", (Throwable)e);
        }
        catch (ParserException e) {
            this.log.error((Object)"ParserException in getEvents", (Throwable)e);
            throw new CalendarException("caught ParserException", (Throwable)e);
        }
    }

    public Set<VEvent> getEvents(Interval interval, Calendar calendar) {
        return this.convertCalendarToEvents(calendar, interval);
    }

    protected final Set<VEvent> convertCalendarToEvents(Calendar calendar, Interval interval) throws CalendarException {
        Period period = new Period(new DateTime(interval.getStartMillis()), new DateTime(interval.getEndMillis()));
        HashSet<VEvent> events = new HashSet<VEvent>();
        if (calendar == null) {
            this.log.warn((Object)"calendar was empty, returning empty set");
            return Collections.emptySet();
        }
        for (Component component : calendar.getComponents()) {
            if (!component.getName().equals("VEVENT")) continue;
            VEvent event = (VEvent)component;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("processing event " + event.getSummary()));
            }
            PeriodList periods = event.calculateRecurrenceSet(period);
            for (Period eventper : periods) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Found time period staring at " + eventper.getStart().isUtc() + ", " + eventper.getStart().getTimeZone() + ", " + event.getStartDate().getTimeZone() + ", " + event.getStartDate().isUtc()));
                }
                PropertyList props = event.getProperties();
                PropertyList newprops = new PropertyList();
                DtStart start = event.getStartDate().getDate() instanceof DateTime ? new DtStart((Date)new DateTime((java.util.Date)eventper.getStart())) : new DtStart(new Date((java.util.Date)eventper.getStart()));
                newprops.add((Property)start);
                if (event.getEndDate() != null) {
                    DtEnd end = event.getEndDate().getDate() instanceof DateTime ? new DtEnd((Date)new DateTime((java.util.Date)eventper.getEnd())) : new DtEnd(new Date((java.util.Date)eventper.getEnd()));
                    newprops.add((Property)end);
                }
                for (Property prop : props) {
                    if (prop instanceof DtStart || prop instanceof DtEnd || prop instanceof Duration || prop instanceof RRule || prop instanceof RDate || prop instanceof ExRule || prop instanceof ExDate) continue;
                    newprops.add(prop);
                }
                VEvent newevent = new VEvent(newprops);
                events.add(newevent);
                this.log.trace((Object)("added event " + newevent));
            }
        }
        return events;
    }
}

