/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.mvc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.calendar.CalendarConfiguration;
import org.jasig.portlet.calendar.CalendarConfigurationByNameComparator;
import org.jasig.portlet.calendar.CalendarSet;
import org.jasig.portlet.calendar.adapter.CalendarEventsDao;
import org.jasig.portlet.calendar.adapter.ICalendarAdapter;
import org.jasig.portlet.calendar.adapter.UserFeedbackCalendarException;
import org.jasig.portlet.calendar.dao.ICalendarSetDao;
import org.jasig.portlet.calendar.mvc.CalendarDisplayEvent;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class CalendarHelper
implements ApplicationContextAware {
    protected static final Log log = LogFactory.getLog(CalendarHelper.class);
    @Autowired(required=true)
    private CalendarEventsDao calendarEventsDao;
    @Autowired(required=true)
    private ICalendarSetDao calendarSetDao;
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Set<CalendarDisplayEvent> getEventList(List<String> errors, Interval interval, PortletRequest request) {
        PortletSession session = request.getPortletSession();
        CalendarSet<?> set = this.calendarSetDao.getCalendarSet(request);
        ArrayList calendars = new ArrayList();
        calendars.addAll(set.getConfigurations());
        Collections.sort(calendars, new CalendarConfigurationByNameComparator());
        HashMap hiddenCalendars = (HashMap)session.getAttribute("hiddenCalendars");
        String timezone = (String)session.getAttribute("timezone");
        DateTimeZone tz = DateTimeZone.forID((String)timezone);
        Set<CalendarDisplayEvent> events = new TreeSet<CalendarDisplayEvent>();
        for (CalendarConfiguration callisting : calendars) {
            if (hiddenCalendars.get(callisting.getId()) != null) continue;
            try {
                ICalendarAdapter adapter = (ICalendarAdapter)this.applicationContext.getBean(callisting.getCalendarDefinition().getClassName());
                events = this.calendarEventsDao.getEvents(adapter, callisting, interval, request, tz);
            }
            catch (NoSuchBeanDefinitionException ex) {
                log.error((Object)("Calendar class instance could not be found: " + ex.getMessage()));
            }
            catch (UserFeedbackCalendarException sce) {
                StringBuilder msg = new StringBuilder();
                msg.append(callisting.getCalendarDefinition().getName()).append(":  ").append(sce.getUserFeedback());
                errors.add(msg.toString());
            }
            catch (Exception ex) {
                log.warn((Object)"Unknown Error", (Throwable)ex);
                errors.add("The calendar \"" + callisting.getCalendarDefinition().getName() + "\" is currently unavailable.");
            }
        }
        return events;
    }
}

