/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.mvc.controller;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Resource;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.model.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.calendar.CalendarConfiguration;
import org.jasig.portlet.calendar.adapter.CalendarEventsDao;
import org.jasig.portlet.calendar.adapter.CalendarException;
import org.jasig.portlet.calendar.adapter.ICalendarAdapter;
import org.jasig.portlet.calendar.dao.CalendarStore;
import org.jasig.portlet.calendar.dao.ICalendarSetDao;
import org.jasig.portlet.calendar.mvc.CalendarDisplayEvent;
import org.jasig.portlet.calendar.mvc.CalendarHelper;
import org.jasig.portlet.calendar.mvc.JsonCalendarEventWrapper;
import org.jasig.portlet.calendar.util.DateUtil;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class AjaxCalendarController
implements ApplicationContextAware {
    protected final Log log = LogFactory.getLog(this.getClass());
    @Autowired(required=true)
    private CalendarHelper helper;
    @Autowired(required=true)
    private CalendarEventsDao calendarEventsDao;
    @Autowired(required=true)
    private ICalendarSetDao calendarSetDao;
    private CalendarStore calendarStore;
    private ApplicationContext applicationContext;

    @ActionMapping(params={"action=showDatePicker"})
    public void toggleShowDatePicker(@RequestParam(value="show") String show, ActionRequest request, ActionResponse response) {
        try {
            request.getPreferences().setValue("showDatePicker", show);
            request.getPreferences().store();
        }
        catch (Exception exception) {
            this.log.info((Object)("Exception encountered saving preference: PREFERENCE=showDatePicker, EXCEPTION=" + exception));
        }
    }

    @ResourceMapping
    public ModelAndView getEventList(ResourceRequest request, ResourceResponse response) throws Exception {
        String resourceId = request.getResourceID();
        String[] resourceIdTokens = resourceId.split("-");
        String startDate = resourceIdTokens[0];
        int days = Integer.parseInt(resourceIdTokens[1]);
        boolean refresh = resourceIdTokens.length > 2 ? Boolean.valueOf(resourceIdTokens[2]) : false;
        long startTime = System.currentTimeMillis();
        ArrayList<String> errors = new ArrayList<String>();
        HashMap<String, Object> model = new HashMap<String, Object>();
        PortletSession session = request.getPortletSession();
        String timezone = (String)session.getAttribute("timezone");
        DateTimeZone tz = DateTimeZone.forID((String)timezone);
        Interval interval = DateUtil.getInterval(startDate, days, (PortletRequest)request);
        Set<CalendarDisplayEvent> calendarEvents = this.helper.getEventList(errors, interval, (PortletRequest)request);
        int index = 0;
        TreeSet<JsonCalendarEventWrapper> events = new TreeSet<JsonCalendarEventWrapper>();
        for (CalendarDisplayEvent e : calendarEvents) {
            events.add(new JsonCalendarEventWrapper(e, index++));
        }
        DateTimeFormatter orderableDf = new DateTimeFormatterBuilder().appendYear(4, 4).appendLiteral("-").appendMonthOfYear(2).appendLiteral("-").appendDayOfMonth(2).toFormatter().withZone(tz);
        DateTimeFormatter displayDf = new DateTimeFormatterBuilder().appendDayOfWeekText().appendLiteral(" ").appendMonthOfYearText().appendLiteral(" ").appendDayOfMonth(1).toFormatter().withZone(tz);
        DateMidnight now = new DateMidnight(tz);
        String today = orderableDf.print((ReadableInstant)now);
        String tomorrow = orderableDf.print((ReadableInstant)now.plusDays(1));
        HashMap<String, String> dateDisplayNames = new HashMap<String, String>();
        LinkedHashMap eventsByDay = new LinkedHashMap();
        for (JsonCalendarEventWrapper event : events) {
            String day = orderableDf.print((ReadableInstant)event.getEvent().getDayStart());
            if (!eventsByDay.containsKey(day)) {
                eventsByDay.put(day, new ArrayList());
                if (today.equals(day)) {
                    dateDisplayNames.put(day, "Today");
                } else if (tomorrow.equals(day)) {
                    dateDisplayNames.put(day, "Tomorrow");
                } else {
                    dateDisplayNames.put(day, displayDf.print((ReadableInstant)event.getEvent().getDayStart()));
                }
            }
            ((List)eventsByDay.get(day)).add(event);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Prepared the following eventsByDay collection for user '" + request.getRemoteUser() + "':" + eventsByDay));
        }
        model.put("dateMap", eventsByDay);
        model.put("dateNames", dateDisplayNames);
        model.put("viewName", "jsonView");
        model.put("errors", errors);
        String etag = String.valueOf(model.hashCode());
        String requestEtag = request.getETag();
        if (!refresh && request.getETag() != null && etag.equals(requestEtag)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Sending an empty response (due to matched ETag and refresh=false) for user '" + request.getRemoteUser() + "'"));
            }
            response.getCacheControl().setExpirationTime(1);
            response.getCacheControl().setUseCachedContent(true);
            return new ModelAndView("empty", Collections.emptyMap());
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Sending a full response for user '" + request.getRemoteUser() + "' and refresh=" + refresh));
        }
        response.getCacheControl().setETag(etag);
        response.getCacheControl().setExpirationTime(1);
        long overallTime = System.currentTimeMillis() - startTime;
        this.log.debug((Object)("AjaxCalendarController took " + overallTime + " ms to produce JSON model"));
        return new ModelAndView("json", model);
    }

    @ResourceMapping(value="exportUserCalendar")
    public String exportCalendar(ResourceRequest request, ResourceResponse response, @RequestParam(value="configurationId") Long id) {
        CalendarConfiguration calendarConfig = this.calendarStore.getCalendarConfiguration(id);
        CalendarException exception = null;
        try {
            ICalendarAdapter adapter = (ICalendarAdapter)this.applicationContext.getBean(calendarConfig.getCalendarDefinition().getClassName());
            DateTime intervalStart = new DateTime().minusYears(1);
            DateTime intervalEnd = new DateTime().plusYears(1);
            Interval interval = new Interval((ReadableInstant)intervalStart, (ReadableInstant)intervalEnd);
            Calendar calendar = this.calendarEventsDao.getCalendar(adapter, calendarConfig, interval, (PortletRequest)request);
            response.setContentType("text/calendar");
            response.addProperty("Content-disposition", "attachment; filename=calendar.ics");
            CalendarOutputter calendarOut = new CalendarOutputter();
            calendarOut.output(calendar, (Writer)response.getWriter());
            response.flushBuffer();
            return null;
        }
        catch (NoSuchBeanDefinitionException ex) {
            exception = new CalendarException("Calendar adapter class instance could not be found", ex);
        }
        catch (Exception ex) {
            exception = new CalendarException("Error sending calendar " + calendarConfig.getCalendarDefinition().getName() + " to user for downloading", ex);
        }
        throw exception;
    }

    @Required
    @Resource(name="calendarStore")
    public void setCalendarStore(CalendarStore calendarStore) {
        this.calendarStore = calendarStore;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

