/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.adapter;

import com.microsoft.exchange.messages.FreeBusyResponseType;
import com.microsoft.exchange.messages.GetUserAvailabilityRequest;
import com.microsoft.exchange.messages.GetUserAvailabilityResponse;
import com.microsoft.exchange.types.ArrayOfCalendarEvent;
import com.microsoft.exchange.types.ArrayOfMailboxData;
import com.microsoft.exchange.types.CalendarEvent;
import com.microsoft.exchange.types.DayOfWeekType;
import com.microsoft.exchange.types.Duration;
import com.microsoft.exchange.types.FreeBusyViewOptions;
import com.microsoft.exchange.types.Mailbox;
import com.microsoft.exchange.types.MailboxData;
import com.microsoft.exchange.types.MeetingAttendeeType;
import com.microsoft.exchange.types.SerializableTimeZoneTime;
import java.io.Serializable;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.portlet.PortletRequest;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStamp;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.model.property.Uid;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.calendar.CalendarConfiguration;
import org.jasig.portlet.calendar.adapter.AbstractCalendarAdapter;
import org.jasig.portlet.calendar.adapter.CalendarEventSet;
import org.jasig.portlet.calendar.adapter.CalendarException;
import org.jasig.portlet.calendar.adapter.CalendarLinkException;
import org.jasig.portlet.calendar.adapter.ExchangeCalendarAdapter;
import org.jasig.portlet.calendar.adapter.ICalendarAdapter;
import org.jasig.portlet.calendar.caching.DefaultCacheKeyGeneratorImpl;
import org.jasig.portlet.calendar.caching.ICacheKeyGenerator;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.client.core.WebServiceOperations;
import org.springframework.ws.soap.client.core.SoapActionCallback;

public class ExchangeCalendarAdapter
extends AbstractCalendarAdapter
implements ICalendarAdapter {
    protected static final String AVAILABILITY_SOAP_ACTION = "http://schemas.microsoft.com/exchange/services/2006/messages/GetUserAvailability";
    protected static final String UTC = "UTC";
    protected final Log log = LogFactory.getLog(this.getClass());
    private WebServiceOperations webServiceOperations;
    private Cache cache;
    private ICacheKeyGenerator cacheKeyGenerator = new DefaultCacheKeyGeneratorImpl();
    private String cacheKeyPrefix = "exchange";
    private String emailAttribute = "mail";
    private String requestServerVersion = "Exchange2010_SP2";

    public void setWebServiceOperations(WebServiceOperations webServiceOperations) {
        this.webServiceOperations = webServiceOperations;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public void setCacheKeyGenerator(ICacheKeyGenerator cacheKeyGenerator) {
        this.cacheKeyGenerator = cacheKeyGenerator;
    }

    public void setCacheKeyPrefix(String cacheKeyPrefix) {
        this.cacheKeyPrefix = cacheKeyPrefix;
    }

    public void setEmailAttribute(String emailAttribute) {
        this.emailAttribute = emailAttribute;
    }

    public void setRequestServerVersion(String requestServerVersion) {
        this.requestServerVersion = requestServerVersion;
    }

    public CalendarEventSet getEvents(CalendarConfiguration calendarConfiguration, Interval interval, PortletRequest request) throws CalendarException {
        CalendarEventSet eventSet;
        Map userInfo = (Map)request.getAttribute("javax.portlet.userinfo");
        String email = (String)userInfo.get(this.emailAttribute);
        String key = this.cacheKeyGenerator.getKey(calendarConfiguration, interval, request, this.cacheKeyPrefix.concat(".").concat(email));
        Element cachedElement = this.cache.get((Serializable)((Object)key));
        if (cachedElement == null) {
            this.log.debug((Object)("Retreiving exchange events for account " + email));
            Set events = this.retrieveExchangeEvents(calendarConfiguration, interval, email);
            this.log.debug((Object)("Exchange adapter found " + events.size() + " events"));
            eventSet = this.insertCalendarEventSetIntoCache(this.cache, key, events);
        } else {
            eventSet = (CalendarEventSet)cachedElement.getValue();
        }
        return eventSet;
    }

    public Set<VEvent> retrieveExchangeEvents(CalendarConfiguration calendar, Interval interval, String emailAddress) throws CalendarException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Retrieving exchange events for period: " + interval));
        }
        HashSet<VEvent> events = new HashSet<VEvent>();
        try {
            GetUserAvailabilityRequest soapRequest = this.getAvailabilityRequest(interval, emailAddress);
            SoapActionCallback actionCallback = new SoapActionCallback(AVAILABILITY_SOAP_ACTION);
            1 customCallback = new /* Unavailable Anonymous Inner Class!! */;
            GetUserAvailabilityResponse response = (GetUserAvailabilityResponse)this.webServiceOperations.marshalSendAndReceive((Object)soapRequest, (WebServiceMessageCallback)customCallback);
            for (FreeBusyResponseType freeBusy : response.getFreeBusyResponseArray().getFreeBusyResponses()) {
                ArrayOfCalendarEvent eventArray = freeBusy.getFreeBusyView().getCalendarEventArray();
                if (eventArray == null || eventArray.getCalendarEvents() == null) continue;
                List msEvents = eventArray.getCalendarEvents();
                for (CalendarEvent msEvent : msEvents) {
                    VEvent event = this.getInternalEvent(calendar.getId().longValue(), msEvent);
                    events.add(event);
                }
            }
        }
        catch (DatatypeConfigurationException e) {
            throw new CalendarException((Throwable)e);
        }
        return events;
    }

    public String getLink(CalendarConfiguration calendar, Interval interval, PortletRequest request) throws CalendarLinkException {
        return "";
    }

    protected GetUserAvailabilityRequest getAvailabilityRequest(Interval interval, String emailAddress) throws DatatypeConfigurationException {
        GetUserAvailabilityRequest soapRequest = new GetUserAvailabilityRequest();
        ArrayOfMailboxData mailboxes = new ArrayOfMailboxData();
        MailboxData mailbox = new MailboxData();
        Mailbox address = new Mailbox();
        address.setAddress(emailAddress);
        address.setName("");
        mailbox.setAttendeeType(MeetingAttendeeType.REQUIRED);
        mailbox.setExcludeConflicts(Boolean.valueOf(false));
        mailbox.setEmail(address);
        mailboxes.getMailboxDatas().add(mailbox);
        soapRequest.setMailboxDataArray(mailboxes);
        FreeBusyViewOptions view = new FreeBusyViewOptions();
        view.setMergedFreeBusyIntervalInMinutes(Integer.valueOf(60));
        view.getRequestedView().add("DetailedMerged");
        Duration dur = new Duration();
        XMLGregorianCalendar start = this.getXmlDate(interval.getStart());
        XMLGregorianCalendar end = this.getXmlDate(interval.getEnd());
        dur.setEndTime(end);
        dur.setStartTime(start);
        view.setTimeWindow(dur);
        soapRequest.setFreeBusyViewOptions(view);
        com.microsoft.exchange.types.TimeZone tz = new com.microsoft.exchange.types.TimeZone();
        TimeZone tZone = TimeZone.getTimeZone(UTC);
        tz.setBias(tZone.getRawOffset() / 1000 / 60);
        SerializableTimeZoneTime standard = new SerializableTimeZoneTime();
        standard.setBias(0);
        standard.setDayOfWeek(DayOfWeekType.SUNDAY);
        standard.setDayOrder((short)1);
        standard.setMonth((short)11);
        standard.setTime("02:00:00");
        SerializableTimeZoneTime daylight = new SerializableTimeZoneTime();
        daylight.setBias(0);
        daylight.setDayOfWeek(DayOfWeekType.SUNDAY);
        daylight.setDayOrder((short)1);
        daylight.setMonth((short)3);
        daylight.setTime("02:00:00");
        tz.setStandardTime(standard);
        tz.setDaylightTime(daylight);
        soapRequest.setTimeZone(tz);
        return soapRequest;
    }

    protected VEvent getInternalEvent(long calendarId, CalendarEvent msEvent) throws DatatypeConfigurationException {
        DatatypeFactory factory = DatatypeFactory.newInstance();
        net.fortuna.ical4j.model.DateTime eventStart = new net.fortuna.ical4j.model.DateTime();
        eventStart.setUtc(true);
        GregorianCalendar startCal = msEvent.getStartTime().toGregorianCalendar(TimeZone.getTimeZone(UTC), Locale.getDefault(), factory.newXMLGregorianCalendar());
        eventStart.setTime(startCal.getTimeInMillis());
        net.fortuna.ical4j.model.DateTime eventEnd = new net.fortuna.ical4j.model.DateTime();
        eventEnd.setUtc(true);
        GregorianCalendar endCal = msEvent.getEndTime().toGregorianCalendar(TimeZone.getTimeZone(UTC), Locale.getDefault(), factory.newXMLGregorianCalendar());
        eventEnd.setTime(endCal.getTimeInMillis());
        PropertyList newprops = new PropertyList();
        newprops.add((Property)new Uid(msEvent.getCalendarEventDetails().getID()));
        newprops.add((Property)new DtStamp());
        newprops.add((Property)new DtStart((Date)eventStart));
        newprops.add((Property)new DtEnd((Date)eventEnd));
        newprops.add((Property)new Summary(msEvent.getCalendarEventDetails().getSubject()));
        if (StringUtils.isNotBlank((String)msEvent.getCalendarEventDetails().getLocation())) {
            newprops.add((Property)new Location(msEvent.getCalendarEventDetails().getLocation()));
        }
        VEvent event = new VEvent(newprops);
        return event;
    }

    protected XMLGregorianCalendar getXmlDate(DateTime date) throws DatatypeConfigurationException {
        DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
        XMLGregorianCalendar start = datatypeFactory.newXMLGregorianCalendar();
        start.setYear(date.getYear());
        start.setMonth(date.getMonthOfYear());
        start.setTime(date.getHourOfDay(), date.getMinuteOfHour(), date.getSecondOfMinute(), date.getMillisOfSecond());
        start.setDay(date.getDayOfMonth());
        return start;
    }

    static /* synthetic */ String access$000(ExchangeCalendarAdapter x0) {
        return x0.requestServerVersion;
    }
}

