/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.adapter;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.fortuna.ical4j.model.component.VEvent;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.calendar.adapter.CalendarEventSet;
import org.jasig.portlet.calendar.adapter.ICalendarAdapter;
import org.jasig.portlet.form.parameter.Parameter;

public abstract class AbstractCalendarAdapter
implements ICalendarAdapter {
    protected final Log log = LogFactory.getLog(this.getClass());
    private String titleKey;
    private String descriptionKey;
    private List<Parameter> parameters = Collections.emptyList();

    public String getTitleKey() {
        return this.titleKey;
    }

    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public void setTitleKey(String titleKey) {
        this.titleKey = titleKey;
    }

    public void setDescriptionKey(String descriptionKey) {
        this.descriptionKey = descriptionKey;
    }

    protected CalendarEventSet insertCalendarEventSetIntoCache(Cache cache, String processorCacheKey, Set<VEvent> events, int secondsToLive) {
        CalendarEventSet eventSet = new CalendarEventSet(processorCacheKey, events);
        Element cachedElement = new Element((Serializable)((Object)processorCacheKey), (Serializable)eventSet);
        if (secondsToLive >= 0) {
            cachedElement.setTimeToLive(secondsToLive);
        }
        if (this.log.isDebugEnabled()) {
            String message = "Storing calendar event set to cache, key:" + processorCacheKey + (secondsToLive > 0 ? " with expiration in " + secondsToLive + " seconds" : "");
            this.log.debug((Object)message);
        }
        cache.put(cachedElement);
        eventSet.setExpirationTime(cachedElement.getExpirationTime());
        return eventSet;
    }

    protected CalendarEventSet insertCalendarEventSetIntoCache(Cache cache, String processorCacheKey, Set<VEvent> events) {
        return this.insertCalendarEventSetIntoCache(cache, processorCacheKey, events, -1);
    }
}

