/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.mvc.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;
import javax.portlet.Event;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.jasig.portal.search.PortletUrl;
import org.jasig.portal.search.PortletUrlParameter;
import org.jasig.portal.search.SearchConstants;
import org.jasig.portal.search.SearchRequest;
import org.jasig.portal.search.SearchResult;
import org.jasig.portal.search.SearchResults;
import org.jasig.portlet.calendar.mvc.CalendarDisplayEvent;
import org.jasig.portlet.calendar.mvc.CalendarHelper;
import org.jasig.portlet.calendar.util.DateUtil;
import org.joda.time.DateMidnight;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.annotation.EventMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class SearchContentController {
    private static final DateTimeFormatter fmt_date = DateTimeFormat.forPattern((String)"MMMM d, yyyy");
    private static final DateTimeFormatter fmt_time = DateTimeFormat.forPattern((String)"m:h a");
    @Autowired(required=true)
    private CalendarHelper helper;

    @EventMapping(value="{https://source.jasig.org/schemas/uportal/search}SearchRequest")
    public void searchContent(EventRequest request, EventResponse response) {
        Event event = request.getEvent();
        SearchRequest searchQuery = (SearchRequest)event.getValue();
        String[] searchTerms = searchQuery.getSearchTerms().split(" ");
        ArrayList errors = new ArrayList();
        DateMidnight start = new DateMidnight();
        Interval interval = DateUtil.getInterval((DateMidnight)start, (int)180);
        Set events = this.helper.getEventList(errors, interval, (PortletRequest)request);
        SearchResults searchResults = new SearchResults();
        searchResults.setQueryId(searchQuery.getQueryId());
        searchResults.setWindowId(request.getWindowID());
        for (CalendarDisplayEvent e : events) {
            for (String term : searchTerms) {
                if (!this.eventContainsTerm(e, term)) continue;
                PortletUrl url = this.createPortletUrl(e);
                SearchResult searchResult = new SearchResult();
                String summary = this.createSearchResultSummary(e);
                searchResult.setTitle(e.getSummary());
                searchResult.setSummary(summary);
                searchResult.setPortletUrl(url);
                searchResults.getSearchResult().add(searchResult);
            }
        }
        if (!searchResults.getSearchResult().isEmpty()) {
            response.setEvent(SearchConstants.SEARCH_RESULTS_QNAME, (Serializable)searchResults);
        }
    }

    private boolean eventContainsTerm(CalendarDisplayEvent event, String term) {
        String summary = StringUtils.isEmpty((String)event.getSummary()) ? "" : event.getSummary().toUpperCase();
        String description = StringUtils.isEmpty((String)event.getDescription()) ? "" : event.getDescription().toUpperCase();
        String check = StringUtils.isEmpty((String)term) ? "" : term.toUpperCase();
        return !StringUtils.isEmpty((String)check) && (summary.contains(check) || description.contains(check));
    }

    private PortletUrl createPortletUrl(CalendarDisplayEvent event) {
        DateMidnight midnight = new DateMidnight((Object)event.getDayStart());
        Interval interval = DateUtil.getInterval((DateMidnight)midnight, (int)1);
        PortletUrl url = new PortletUrl();
        PortletUrlParameter param = new PortletUrlParameter();
        param.setName("interval");
        param.getValue().add(interval.toString());
        url.getParam().add(param);
        return url;
    }

    private String createSearchResultSummary(CalendarDisplayEvent event) {
        StringBuilder summary = new StringBuilder(fmt_date.print((ReadableInstant)event.getDayStart()));
        if (!event.getDateStartTime().equals(event.getDateEndTime())) {
            summary.append(" ").append(event.getDateStartTime()).append(" - ").append(event.getDateEndTime());
        }
        return summary.toString();
    }
}

