/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.mvc;

import javax.portlet.PortletRequest;
import javax.portlet.WindowState;
import org.jasig.portlet.calendar.mvc.IViewSelector;

public class ThemeNameViewSelectorImpl
implements IViewSelector {
    private final String CALENDAR_WIDE_VIEW = "calendarWideView";
    private final String CALENDAR_NARROW_VIEW = "calendarNarrowView";
    private final String CALENDAR_MOBILE_VIEW = "calendarMobileView";
    protected static final String THEME_NAME_PROPERTY = "themeName";
    protected static final String MOBILE_THEMES_KEY = "mobileThemes";
    protected static final String[] MOBILE_THEMES_DEFAULT = new String[]{"UniversalityMobile"};

    @Override
    public String getCalendarViewName(PortletRequest request) {
        if (this.isMobile(request)) {
            return "calendarMobileView";
        }
        WindowState state = request.getWindowState();
        if (WindowState.MAXIMIZED.equals((Object)state) || "DETACHED".equalsIgnoreCase(state.toString())) {
            return "calendarWideView";
        }
        return "calendarNarrowView";
    }

    @Override
    public String getEditViewName(PortletRequest request) {
        if (this.isMobile(request)) {
            return "editCalendars-jQM";
        }
        return "editCalendars";
    }

    @Override
    public String getEventListViewName(PortletRequest request) {
        return "ajaxEventList";
    }

    protected boolean isMobile(PortletRequest request) {
        String[] mobileThemes = request.getPreferences().getValues(MOBILE_THEMES_KEY, MOBILE_THEMES_DEFAULT);
        String themeName = request.getProperty(THEME_NAME_PROPERTY);
        if (themeName == null) {
            return false;
        }
        for (String theme : mobileThemes) {
            if (!themeName.equals(theme)) continue;
            return true;
        }
        return false;
    }
}

