/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.service;

import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.jasig.portlet.calendar.service.IRoleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ServletContextAware;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class RoleService
implements IRoleService,
ServletContextAware {
    private static final String PORTLET_XML_PATH = "/WEB-INF/portlet.xml";
    private static final String ROLES_XPATH = "//security-role-ref/role-link/text()";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ServletContext context;
    private Set<String> cachedRoles;

    public void setServletContext(ServletContext context) {
        this.context = context;
    }

    public synchronized Set<String> getKnownRoles() {
        if (this.cachedRoles != null) {
            return this.cachedRoles;
        }
        this.cachedRoles = this.readRolesFromPortletXml();
        return this.cachedRoles;
    }

    private Set<String> readRolesFromPortletXml() {
        try {
            URL portletXmlUrl = this.context.getResource(PORTLET_XML_PATH);
            InputSource is = new InputSource(portletXmlUrl.openStream());
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
            Document doc = builder.parse(is);
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPath xpath = xpathFactory.newXPath();
            XPathExpression xPathExpression = xpath.compile(ROLES_XPATH);
            NodeList nodeList = (NodeList)xPathExpression.evaluate(doc, XPathConstants.NODESET);
            LinkedHashSet<String> roles = new LinkedHashSet<String>();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String role = nodeList.item(i).getNodeValue();
                roles.add(role);
            }
            return roles;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("Error reading roles from portlet.xml", e);
        }
    }
}

