/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.mvc;

import net.fortuna.ical4j.model.component.VEvent;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.format.DateTimeFormatter;

public class CalendarDisplayEvent
implements Comparable<CalendarDisplayEvent> {
    private final DateTime dayStart;
    private final DateTime dayEnd;
    private final boolean isAllDay;
    private final boolean isMultiDay;
    private final String summary;
    private final String description;
    private final String location;
    private final String dateStartTime;
    private final String dateEndTime;
    private final String startTime;
    private final String endTime;
    private final String startDate;
    private final String endDate;

    public CalendarDisplayEvent(VEvent event, Interval eventInterval, Interval theSpecificDay, DateTimeFormatter df, DateTimeFormatter tf) {
        assert (theSpecificDay.abuts((ReadableInterval)eventInterval) || theSpecificDay.overlaps((ReadableInterval)eventInterval)) : "Event interval is not in the specified day!";
        this.summary = event.getSummary() != null ? event.getSummary().getValue() : null;
        this.description = event.getDescription() != null ? event.getDescription().getValue() : null;
        this.location = event.getLocation() != null ? event.getLocation().getValue() : null;
        boolean multi = false;
        if (eventInterval.getStart().isBefore((ReadableInstant)theSpecificDay.getStart())) {
            this.dayStart = theSpecificDay.getStart();
            multi = true;
        } else {
            this.dayStart = eventInterval.getStart();
        }
        if (event.getEndDate() == null) {
            this.dayEnd = this.dayStart;
        } else if (eventInterval.getEnd().isAfter((ReadableInstant)theSpecificDay.getEnd())) {
            this.dayEnd = theSpecificDay.getEnd();
            multi = true;
        } else {
            this.dayEnd = eventInterval.getEnd();
        }
        this.isMultiDay = multi;
        this.dateStartTime = tf.print((ReadableInstant)this.dayStart);
        this.startTime = tf.print((ReadableInstant)eventInterval.getStart());
        this.startDate = df.print((ReadableInstant)eventInterval.getStart());
        if (event.getEndDate() != null) {
            this.dateEndTime = tf.print((ReadableInstant)this.dayEnd);
            this.endTime = tf.print((ReadableInstant)eventInterval.getEnd());
            this.endDate = df.print((ReadableInstant)eventInterval.getEnd());
        } else {
            this.dateEndTime = null;
            this.endTime = null;
            this.endDate = null;
        }
        Interval dayEventInterval = new Interval((ReadableInstant)this.dayStart, (ReadableInstant)this.dayEnd);
        this.isAllDay = dayEventInterval.equals((Object)theSpecificDay);
    }

    public String getSummary() {
        return this.summary;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDateStartTime() {
        return this.dateStartTime;
    }

    public String getDateEndTime() {
        return this.dateEndTime;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public boolean isAllDay() {
        return this.isAllDay;
    }

    public boolean isMultiDay() {
        return this.isMultiDay;
    }

    public DateTime getDayStart() {
        return this.dayStart;
    }

    public DateTime getDayEnd() {
        return this.dayEnd;
    }

    @Override
    public int compareTo(CalendarDisplayEvent event) {
        return new CompareToBuilder().append((Object)this.dayStart, (Object)event.dayStart).append((Object)this.dayEnd, (Object)event.dayEnd).append((Object)this.getSummary(), (Object)event.getSummary()).toComparison();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CalendarDisplayEvent)) {
            return false;
        }
        CalendarDisplayEvent event = (CalendarDisplayEvent)o;
        return new EqualsBuilder().append((Object)this.dayStart, (Object)event.dayStart).append((Object)this.dayEnd, (Object)event.dayEnd).append((Object)this.getSummary(), (Object)event.getSummary()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 31).append((Object)this.dayStart).append((Object)this.dayEnd).append((Object)this.getSummary()).toHashCode();
    }
}

