/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.mvc.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.calendar.CalendarConfiguration;
import org.jasig.portlet.calendar.CalendarConfigurationByNameComparator;
import org.jasig.portlet.calendar.CalendarSet;
import org.jasig.portlet.calendar.adapter.CalendarLinkException;
import org.jasig.portlet.calendar.adapter.ICalendarAdapter;
import org.jasig.portlet.calendar.dao.ICalendarSetDao;
import org.jasig.portlet.calendar.mvc.IViewSelector;
import org.joda.time.DateMidnight;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.ActionMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class CalendarController
implements ApplicationContextAware {
    public static final String PREFERENCE_DISABLE_PREFERENCES = "disablePreferences";
    public static final String PREFERENCE_DISABLE_ADMINISTRATION = "disableAdministration";
    protected final Log log = LogFactory.getLog(this.getClass());
    @Autowired
    private ICalendarSetDao calendarSetDao;
    @Autowired
    private IViewSelector viewSelector;
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @ActionMapping
    public void defaultAction() {
    }

    @RequestMapping
    public ModelAndView getCalendar(@RequestParam(required=false, value="interval") String intervalString, RenderRequest request) {
        String showCalendar;
        PortletSession session = request.getPortletSession(true);
        PortletPreferences prefs = request.getPreferences();
        HashMap<String, Object> model = new HashMap<String, Object>();
        HashMap hiddenCalendars = (HashMap)session.getAttribute("hiddenCalendars");
        model.put("guest", request.getRemoteUser() == null);
        String hideCalendar = request.getParameter("hideCalendar");
        if (hideCalendar != null) {
            hiddenCalendars.put(Long.valueOf(hideCalendar), "true");
            session.setAttribute("hiddenCalendars", (Object)hiddenCalendars);
        }
        if ((showCalendar = request.getParameter("showCalendar")) != null) {
            hiddenCalendars.remove(Long.valueOf(showCalendar));
            session.setAttribute("hiddenCalendars", (Object)hiddenCalendars);
        }
        String showDatePicker = prefs.getValue("showDatePicker", "true");
        model.put("showDatePicker", showDatePicker);
        Interval interval = null;
        if (!StringUtils.isEmpty((String)intervalString)) {
            interval = Interval.parse((String)intervalString);
            model.put("startDate", new DateMidnight((Object)interval.getStart()).toDate());
            model.put("days", interval.toDuration().getStandardDays());
            model.put("endDate", new DateMidnight((Object)interval.getEnd()));
        } else {
            DateMidnight startDate = (DateMidnight)session.getAttribute("startDate");
            this.log.debug((Object)("startDate from session is: " + startDate));
            model.put("startDate", startDate.toDate());
            int days = (Integer)session.getAttribute("days");
            model.put("days", days);
            DateMidnight endDate = startDate.plusDays(days);
            model.put("endDate", endDate.toDate());
            interval = new Interval((ReadableInstant)startDate, (ReadableInstant)endDate);
        }
        String timezone = (String)session.getAttribute("timezone");
        DateMidnight today = new DateMidnight(DateTimeZone.forID((String)timezone));
        model.put("today", today.toDate());
        model.put("tomorrow", today.plusDays(1).toDate());
        CalendarSet set = this.calendarSetDao.getCalendarSet((PortletRequest)request);
        ArrayList calendars = new ArrayList();
        calendars.addAll(set.getConfigurations());
        Collections.sort(calendars, new CalendarConfigurationByNameComparator());
        model.put("calendars", calendars);
        HashMap<Long, Integer> colors = new HashMap<Long, Integer>();
        HashMap<Long, String> links = new HashMap<Long, String>();
        int index = 0;
        for (CalendarConfiguration callisting : calendars) {
            if (hiddenCalendars.get(callisting.getId()) == null) {
                try {
                    ICalendarAdapter adapter = (ICalendarAdapter)this.applicationContext.getBean(callisting.getCalendarDefinition().getClassName());
                    String link = adapter.getLink(callisting, interval, (PortletRequest)request);
                    if (link != null) {
                        links.put(callisting.getId(), link);
                    }
                }
                catch (NoSuchBeanDefinitionException ex) {
                    this.log.error((Object)("Calendar class instance could not be found: " + ex.getMessage()));
                }
                catch (CalendarLinkException linkEx) {
                }
                catch (Exception ex) {
                    this.log.error((Object)ex);
                }
            }
            colors.put(callisting.getId(), index);
            ++index;
        }
        model.put("timezone", session.getAttribute("timezone"));
        model.put("colors", colors);
        model.put("links", links);
        model.put("hiddenCalendars", hiddenCalendars);
        Boolean disablePrefs = Boolean.valueOf(prefs.getValue(PREFERENCE_DISABLE_PREFERENCES, "false"));
        model.put(PREFERENCE_DISABLE_PREFERENCES, disablePrefs);
        Boolean disableAdmin = Boolean.valueOf(prefs.getValue(PREFERENCE_DISABLE_ADMINISTRATION, "false"));
        model.put(PREFERENCE_DISABLE_ADMINISTRATION, disableAdmin);
        return new ModelAndView(this.viewSelector.getCalendarViewName((PortletRequest)request), "model", model);
    }
}

