/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.mvc;

import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.jasig.portlet.calendar.service.IInitializationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.portlet.HandlerInterceptor;
import org.springframework.web.portlet.ModelAndView;

public class UserSessionInitializer
implements HandlerInterceptor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private List<IInitializationService> initializationServices;

    public void setInitializationServices(List<IInitializationService> initializationServices) {
        this.initializationServices = initializationServices;
    }

    private void callInitializers(PortletRequest request) {
        PortletSession session = request.getPortletSession(true);
        if (session.getAttribute("initialized") == null) {
            this.log.info("initializing session for {}", (Object)request.getRemoteUser());
            for (IInitializationService service : this.initializationServices) {
                try {
                    this.log.info("calling initialize(request) on {}", (Object)service.getClass().toString());
                    service.initialize(request);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.log.error("Issue with initialize call in filter: ", service.getClass());
                }
            }
        }
    }

    public boolean preHandleAction(ActionRequest actionRequest, ActionResponse actionResponse, Object o) throws Exception {
        this.callInitializers((PortletRequest)actionRequest);
        return true;
    }

    public void afterActionCompletion(ActionRequest actionRequest, ActionResponse actionResponse, Object o, Exception e) throws Exception {
    }

    public boolean preHandleRender(RenderRequest renderRequest, RenderResponse renderResponse, Object o) throws Exception {
        this.callInitializers((PortletRequest)renderRequest);
        return true;
    }

    public void postHandleRender(RenderRequest renderRequest, RenderResponse renderResponse, Object o, ModelAndView modelAndView) throws Exception {
    }

    public void afterRenderCompletion(RenderRequest renderRequest, RenderResponse renderResponse, Object o, Exception e) throws Exception {
    }

    public boolean preHandleResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse, Object o) throws Exception {
        this.callInitializers((PortletRequest)resourceRequest);
        return true;
    }

    public void postHandleResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse, Object o, ModelAndView modelAndView) throws Exception {
    }

    public void afterResourceCompletion(ResourceRequest resourceRequest, ResourceResponse resourceResponse, Object o, Exception e) throws Exception {
    }

    public boolean preHandleEvent(EventRequest eventRequest, EventResponse eventResponse, Object o) throws Exception {
        this.callInitializers((PortletRequest)eventRequest);
        return true;
    }

    public void afterEventCompletion(EventRequest eventRequest, EventResponse eventResponse, Object o, Exception e) throws Exception {
    }
}

