/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.dao;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.jasig.portlet.calendar.CalendarConfiguration;
import org.jasig.portlet.calendar.CalendarSet;
import org.jasig.portlet.calendar.PredefinedCalendarConfiguration;
import org.jasig.portlet.calendar.PredefinedCalendarDefinition;
import org.jasig.portlet.calendar.dao.ICalendarSetDao;

public class WhitelistFilteringCalendarSetDao
implements ICalendarSetDao {
    private ICalendarSetDao enclosedCalendarSetDao;
    private static final String CALENDAR_WHITELIST_PREFERENCE = "calendarWhitelist";

    public void setEnclosedCalendarSetDao(ICalendarSetDao enclosedCalendarSetDao) {
        this.enclosedCalendarSetDao = enclosedCalendarSetDao;
    }

    @Override
    public CalendarSet<?> getCalendarSet(PortletRequest req) {
        CalendarSet<?> unmodifiedSet = this.enclosedCalendarSetDao.getCalendarSet(req);
        List<String> whitelist = this.getWhitelist(req);
        if (whitelist.size() == 0) {
            return unmodifiedSet;
        }
        HashSet<CalendarConfiguration> configurations = new HashSet<CalendarConfiguration>();
        Set<?> rawSet = unmodifiedSet.getConfigurations();
        for (CalendarConfiguration config : rawSet) {
            if (config.getCalendarDefinition() instanceof PredefinedCalendarDefinition) {
                PredefinedCalendarDefinition pdef = (PredefinedCalendarDefinition)config.getCalendarDefinition();
                if (!whitelist.contains(pdef.getFname())) continue;
                configurations.add(config);
                continue;
            }
            configurations.add(config);
        }
        CalendarSet rslt = new CalendarSet(configurations);
        return rslt;
    }

    @Override
    public List<PredefinedCalendarConfiguration> getAvailablePredefinedCalendarConfigurations(PortletRequest req) {
        List<PredefinedCalendarConfiguration> unmodifiedList = this.enclosedCalendarSetDao.getAvailablePredefinedCalendarConfigurations(req);
        List<String> whitelist = this.getWhitelist(req);
        if (whitelist.size() == 0) {
            return unmodifiedList;
        }
        ArrayList<PredefinedCalendarConfiguration> rslt = new ArrayList<PredefinedCalendarConfiguration>();
        for (PredefinedCalendarConfiguration config : unmodifiedList) {
            PredefinedCalendarDefinition pdef = (PredefinedCalendarDefinition)config.getCalendarDefinition();
            if (!whitelist.contains(pdef.getFname())) continue;
            rslt.add(config);
        }
        return rslt;
    }

    private List<String> getWhitelist(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        List rslt = Arrays.asList((Object[])prefs.getValues(CALENDAR_WHITELIST_PREFERENCE, new String[0]));
        return rslt;
    }
}

