/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.jasig.portlet.calendar.spring.PortletApplicationContextLocator;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.orm.hibernate3.LocalSessionFactoryBean;

public class SchemaCreator
implements ApplicationContextAware {
    private static final String SESSION_FACTORY_BEAN_NAME = "&sessionFactory";
    private static final String DATA_SOURCE_BEAN_NAME = "dataSource";
    private ApplicationContext applicationContext;
    private final Logger logger = Logger.getLogger(this.getClass());

    public static void main(String[] args) {
        ApplicationContext context = PortletApplicationContextLocator.getApplicationContext((String)"classpath:/context/importExportContext.xml");
        SchemaCreator schemaCreator = (SchemaCreator)context.getBean("schemaCreator", SchemaCreator.class);
        System.exit(schemaCreator.create());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int create() {
        LocalSessionFactoryBean sessionFactoryBean = (LocalSessionFactoryBean)this.applicationContext.getBean(SESSION_FACTORY_BEAN_NAME, LocalSessionFactoryBean.class);
        DataSource dataSource = (DataSource)this.applicationContext.getBean(DATA_SOURCE_BEAN_NAME, DataSource.class);
        try (Connection conn = dataSource.getConnection();){
            Configuration cfg = sessionFactoryBean.getConfiguration();
            SchemaExport schemaExport = new SchemaExport(cfg, conn);
            schemaExport.execute(true, true, false, false);
            List exceptions = schemaExport.getExceptions();
            if (exceptions.size() == 0) return 0;
            this.logger.error((Object)"Schema Create Failed;  see below for details");
            for (Exception e : exceptions) {
                this.logger.error((Object)"Exception from Hibernate Tools SchemaExport", (Throwable)e);
            }
            int n = 1;
            return n;
        }
        catch (SQLException sqle) {
            this.logger.error((Object)"Failed to initialize & invoke the SchemaExport tool", (Throwable)sqle);
            return 1;
        }
    }
}

