/**
 * Licensed to Apereo under one or more contributor license
 * agreements. See the NOTICE file distributed with this work
 * for additional information regarding copyright ownership.
 * Apereo licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License.  You may obtain a
 * copy of the License at the following location:
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.jasig.portlet.calendar.adapter.exchange;

import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class ExchangeWsCredentialsProvider implements CredentialsProvider {

  protected static final String EXCHANGE_CREDENTIALS_ATTRIBUTE = "exchangeCredentials";

  @Override
  public void clear() {
    /* no-op */
  }

  @Override
  public Credentials getCredentials(AuthScope authscope) {
    final RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
    final Credentials credentials =
        (Credentials)
            requestAttributes.getAttribute(
                ExchangeWsCredentialsProvider.EXCHANGE_CREDENTIALS_ATTRIBUTE,
                RequestAttributes.SCOPE_SESSION);
    return credentials;
  }

  @Override
  public void setCredentials(AuthScope authscope, Credentials credentials) {
    /* no-op */
  }
}
