/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.dao;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.jasig.portlet.calendar.CalendarSet;
import org.jasig.portlet.calendar.PredefinedCalendarConfiguration;
import org.jasig.portlet.calendar.dao.CalendarStore;
import org.jasig.portlet.calendar.dao.ICalendarSetDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class HibernateCalendarSetDao
implements ICalendarSetDao {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private CalendarStore calendarStore;

    @Required
    @Resource(name="calendarStore")
    public void setCalendarStore(CalendarStore calendarStore) {
        this.calendarStore = calendarStore;
    }

    public CalendarSet<?> getCalendarSet(PortletRequest request) {
        HashSet calendars = new HashSet();
        CalendarSet set = new CalendarSet(calendars);
        String username = this.getUsername(request);
        if (username != null) {
            List cals = this.calendarStore.getCalendarConfigurations(username);
            calendars.addAll(cals);
        } else {
            this.log.warn("username is null -- returning empty calendar set");
        }
        return set;
    }

    public List<PredefinedCalendarConfiguration> getAvailablePredefinedCalendarConfigurations(PortletRequest request) {
        String username = this.getUsername(request);
        if (username != null) {
            return this.calendarStore.getPredefinedCalendarConfigurations(username, false);
        }
        this.log.warn("username is null -- returning empty calendar configuration list");
        return new ArrayList<PredefinedCalendarConfiguration>();
    }

    private String getUsername(PortletRequest request) {
        PortletSession session = request.getPortletSession();
        String rslt = (String)session.getAttribute("username");
        if (rslt == null) {
            this.log.warn("Username not found in session");
        }
        return rslt;
    }
}

