/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.mvc.controller;

import javax.annotation.Resource;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.calendar.CalendarConfiguration;
import org.jasig.portlet.calendar.UserDefinedCalendarConfiguration;
import org.jasig.portlet.calendar.UserDefinedCalendarDefinition;
import org.jasig.portlet.calendar.dao.CalendarStore;
import org.jasig.portlet.calendar.mvc.UserHttpIcalCalendarForm;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.portlet.bind.annotation.ActionMapping;

@Controller
@RequestMapping(value={"EDIT"})
@SessionAttributes(value={"userHttpIcalCalendarForm"})
public class EditUserHttpICalController {
    private static final String FORM_NAME = "userHttpIcalCalendarForm";
    protected final Log log = LogFactory.getLog(this.getClass());
    private CalendarStore calendarStore;

    @Required
    @Resource(name="calendarStore")
    public void setCalendarStore(CalendarStore calendarStore) {
        this.calendarStore = calendarStore;
    }

    @RequestMapping(params={"action=editUrl"})
    public String showHttpCalendarForm(RenderRequest request, Model model) {
        if (!model.containsAttribute(FORM_NAME)) {
            model.addAttribute(FORM_NAME, (Object)this.getHttpCalendarForm((PortletRequest)request));
        }
        return "/editCalendarUrl";
    }

    @ActionMapping(params={"action=editUrl"})
    public void updateHttpCalendar(ActionRequest request, ActionResponse response, @ModelAttribute(value="userHttpIcalCalendarForm") UserHttpIcalCalendarForm form, BindingResult result, SessionStatus status) throws Exception {
        UserDefinedCalendarConfiguration config = null;
        UserDefinedCalendarDefinition definition = null;
        if (form.getId() > -1L) {
            config = (UserDefinedCalendarConfiguration)this.calendarStore.getCalendarConfiguration(form.getId());
            definition = config.getCalendarDefinition();
            definition.addParameter("url", form.getUrl());
            definition.setName(form.getName());
        } else {
            definition = new UserDefinedCalendarDefinition();
            definition.setClassName("httpIcalAdapter");
            definition.addParameter("url", form.getUrl());
            definition.setName(form.getName());
            this.calendarStore.storeCalendarDefinition(definition);
            config = new UserDefinedCalendarConfiguration();
            config.setCalendarDefinition(definition);
            config.setSubscribeId(form.getSubscribeId());
            config.setDisplayed(form.isDisplayed());
        }
        this.calendarStore.storeCalendarConfiguration(config);
        response.setRenderParameter("action", "editSubscriptions");
        status.setComplete();
    }

    protected UserHttpIcalCalendarForm getHttpCalendarForm(PortletRequest request) {
        PortletSession session = request.getPortletSession();
        String id = request.getParameter("id");
        if (id != null && !id.equals("")) {
            Long configurationId = Long.parseLong(id);
            if (configurationId > -1L) {
                CalendarConfiguration listing = this.calendarStore.getCalendarConfiguration(configurationId);
                this.log.debug((Object)("retrieved " + listing.toString()));
                UserHttpIcalCalendarForm command = new UserHttpIcalCalendarForm();
                command.setId(listing.getId());
                command.setName(listing.getCalendarDefinition().getName());
                command.setUrl(listing.getCalendarDefinition().getParameters().get("url"));
                command.setSubscribeId(listing.getSubscribeId());
                command.setDisplayed(listing.isDisplayed());
                return command;
            }
            String subscribeId = (String)session.getAttribute("username");
            UserHttpIcalCalendarForm command = new UserHttpIcalCalendarForm();
            command.setSubscribeId(subscribeId);
            return command;
        }
        String subscribeId = (String)session.getAttribute("username");
        UserHttpIcalCalendarForm command = new UserHttpIcalCalendarForm();
        command.setSubscribeId(subscribeId);
        return command;
    }
}

