/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.adapter.exchange;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthSchemeFactory;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.NTLMEngine;
import org.apache.http.impl.auth.NTLMScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.jasig.portlet.calendar.adapter.exchange.JCIFSEngine;
import org.springframework.beans.factory.InitializingBean;

public class NtlmAuthHttpClient
extends DefaultHttpClient
implements InitializingBean {
    private Map<String, AuthSchemeFactory> authenticationSchemes = null;
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public NtlmAuthHttpClient() {
    }

    public NtlmAuthHttpClient(ClientConnectionManager conman) {
        super(conman);
    }

    public NtlmAuthHttpClient(ClientConnectionManager conman, HttpParams params) {
        super(conman, params);
    }

    public NtlmAuthHttpClient(HttpParams params) {
        super(params);
    }

    public void setAuthenticationSchemes(Map<String, AuthSchemeFactory> authenticationSchemes) {
        this.authenticationSchemes = authenticationSchemes;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.authenticationSchemes == null) {
            this.authenticationSchemes = new HashMap<String, AuthSchemeFactory>();
            NTLMSchemeFactory fac = new NTLMSchemeFactory();
            BasicSchemeFactory bfac = new BasicSchemeFactory();
            this.authenticationSchemes.put("Basic", (AuthSchemeFactory)bfac);
            this.authenticationSchemes.put("NTLM", fac);
            this.authenticationSchemes.put("Negotiate", fac);
        }
        this.setup();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Support is available for the following authenticationSchemes=" + this.authenticationSchemes.keySet()));
        }
    }

    private void setup() {
        this.addRequestInterceptor(new RemoveSoapHeadersInterceptor(), 0);
        for (Map.Entry<String, AuthSchemeFactory> y : this.authenticationSchemes.entrySet()) {
            this.getAuthSchemes().register(y.getKey(), y.getValue());
        }
    }

    private static final class NTLMSchemeFactory
    implements AuthSchemeFactory {
        private NTLMSchemeFactory() {
        }

        public AuthScheme newInstance(HttpParams params) {
            return new NTLMScheme((NTLMEngine)new JCIFSEngine());
        }
    }

    private static final class RemoveSoapHeadersInterceptor
    implements HttpRequestInterceptor {
        private RemoveSoapHeadersInterceptor() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            if (request instanceof HttpEntityEnclosingRequest) {
                if (request.containsHeader("Transfer-Encoding")) {
                    request.removeHeaders("Transfer-Encoding");
                }
                if (request.containsHeader("Content-Length")) {
                    request.removeHeaders("Content-Length");
                }
            }
        }
    }
}

