/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.adapter.exchange;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.http.annotation.Contract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.client.core.SoapActionCallback;
import org.springframework.xml.transform.StringSource;

@Contract
public class ExchangeWebServiceCallBack
implements WebServiceMessageCallback {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String impersonationFirstPart = "<t:ExchangeImpersonation xmlns:t=\"http://schemas.microsoft.com/exchange/services/2006/types\"><t:ConnectingSID><t:PrincipalName>";
    private static final String impersonationSecondPart = "</t:PrincipalName></t:ConnectingSID></t:ExchangeImpersonation>";
    private String impersonatedAccountId;
    private final WebServiceMessageCallback actionCallback;
    private String requestServerVersion;

    public ExchangeWebServiceCallBack(String actionCallbackType, String requestServerVersion, String impersonatedAccountDomainId) {
        this.actionCallback = new SoapActionCallback(actionCallbackType);
        this.requestServerVersion = requestServerVersion;
        this.impersonatedAccountId = impersonatedAccountDomainId;
    }

    public void doWithMessage(WebServiceMessage message) throws IOException, TransformerException {
        this.actionCallback.doWithMessage(message);
        SoapMessage soap = (SoapMessage)message;
        QName rsv = new QName("http://schemas.microsoft.com/exchange/services/2006/types", "RequestServerVersion", "ns3");
        SoapHeaderElement version = soap.getEnvelope().getHeader().addHeaderElement(rsv);
        version.addAttribute(new QName("Version"), this.requestServerVersion);
        if (StringUtils.isNotBlank((String)this.impersonatedAccountId)) {
            StringSource headerSource = new StringSource(impersonationFirstPart + this.impersonatedAccountId + impersonationSecondPart);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform((Source)headerSource, soap.getEnvelope().getHeader().getResult());
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            message.writeTo((OutputStream)bout);
            this.log.debug("Including impersonation header in SOAP message for account {}", (Object)this.impersonatedAccountId);
        }
    }
}

