/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.adapter.exchange;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthSchemeFactory;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;
import org.jasig.portlet.calendar.adapter.exchange.NtlmAuthHttpClient;
import org.springframework.beans.factory.InitializingBean;

public class NtlmAuthHttpClient
extends DefaultHttpClient
implements InitializingBean {
    private Map<String, AuthSchemeFactory> authenticationSchemes = null;
    private final Log log = LogFactory.getLog(this.getClass());

    public NtlmAuthHttpClient() {
    }

    public NtlmAuthHttpClient(ClientConnectionManager conman) {
        super(conman);
    }

    public NtlmAuthHttpClient(ClientConnectionManager conman, HttpParams params) {
        super(conman, params);
    }

    public NtlmAuthHttpClient(HttpParams params) {
        super(params);
    }

    public void setAuthenticationSchemes(Map<String, AuthSchemeFactory> authenticationSchemes) {
        this.authenticationSchemes = authenticationSchemes;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.authenticationSchemes == null) {
            this.authenticationSchemes = new HashMap();
            NTLMSchemeFactory fac = new NTLMSchemeFactory(null);
            BasicSchemeFactory bfac = new BasicSchemeFactory();
            this.authenticationSchemes.put("Basic", bfac);
            this.authenticationSchemes.put("NTLM", fac);
            this.authenticationSchemes.put("Negotiate", fac);
        }
        this.setup();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Support is available for the following authenticationSchemes=" + this.authenticationSchemes.keySet()));
        }
    }

    private void setup() {
        this.addRequestInterceptor((HttpRequestInterceptor)new RemoveSoapHeadersInterceptor(null), 0);
        for (Map.Entry y : this.authenticationSchemes.entrySet()) {
            this.getAuthSchemes().register((String)y.getKey(), (AuthSchemeFactory)y.getValue());
        }
    }
}

