/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.spring;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jasig.portlet.calendar.spring.DoubleCheckedCreator;

public abstract class SingletonDoubleCheckedCreator<T>
extends DoubleCheckedCreator<T> {
    private final AtomicBoolean creating = new AtomicBoolean(false);
    private final AtomicBoolean created = new AtomicBoolean(false);
    private T instance;

    protected abstract T createSingleton(Object ... var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final T create(Object ... args) {
        if (this.creating.get()) {
            throw new IllegalStateException("Singleton creator has been called again while creation is in progress, this is indicative of a creation loop in a single thread");
        }
        this.creating.set(true);
        try {
            T instance = this.createSingleton(args);
            this.instance = instance;
            this.created.set(true);
            T t = instance;
            return t;
        }
        finally {
            this.creating.set(false);
        }
    }

    @Override
    protected final T retrieve(Object ... args) {
        return this.instance;
    }

    public final boolean isCreated() {
        return this.created.get();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("instance", this.instance).toString();
    }
}

