/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.contacts.adapters.impl.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jasig.portlet.contacts.adapters.PushAdapter;
import org.jasig.portlet.contacts.adapters.impl.AbstractContactAdapter;
import org.jasig.portlet.contacts.model.Contact;
import org.jasig.portlet.contacts.model.ContactSet;
import org.springframework.oxm.Unmarshaller;

public class XMLContactAdapter
extends AbstractContactAdapter
implements PushAdapter {
    private Unmarshaller unmarshaller;
    private List<String> dataURIs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ContactSet> getContacts() {
        TreeSet<ContactSet> contacts = new TreeSet<ContactSet>();
        InputStream is = null;
        for (String dataURI : this.dataURIs) {
            try {
                is = this.getClass().getClassLoader().getResourceAsStream(dataURI);
                ContactSet contactSet = (ContactSet)this.unmarshaller.unmarshal((Source)new StreamSource(is));
                contacts.add(contactSet);
            }
            catch (Exception ex) {
                Logger.getLogger(XMLContactAdapter.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                if (is == null) continue;
                try {
                    is.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(XMLContactAdapter.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return contacts;
    }

    @Override
    public ContactSet getContacts(String id) {
        Set<ContactSet> contacts = this.getContacts();
        ContactSet contactSet = null;
        for (ContactSet set : contacts) {
            if (!set.getId().equals(id)) continue;
            contactSet = set;
            break;
        }
        return contactSet;
    }

    @Override
    public Map<String, String> getGroups() {
        Set<ContactSet> contacts = this.getContacts();
        HashMap<String, String> groups = new HashMap<String, String>();
        for (ContactSet set : contacts) {
            groups.put(set.getTitle(), set.getId());
        }
        return groups;
    }

    public void setDataURIs(List<String> setSourceURIs) {
        this.dataURIs = setSourceURIs;
    }

    @Override
    protected String[] requiredAttributes() {
        return new String[0];
    }

    public void setUnmarshaller(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    @Override
    public Contact getByURN(String URN) {
        Set<ContactSet> contacts = this.getContacts();
        for (ContactSet set : contacts) {
            for (Contact contact : set) {
                if (!contact.getURN().equals(URN)) continue;
                return contact;
            }
        }
        return null;
    }
}

