/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.contacts.context.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.contacts.context.ContactContext;
import org.jasig.portlet.contacts.context.ContextProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class ContactContextImpl
implements ContactContext {
    private static Log log = LogFactory.getLog(ContactContextImpl.class);
    private Map<String, Object> context = new HashMap<String, Object>();
    private final List<ContextProvider> contextProviders = new ArrayList<ContextProvider>();

    private void prime() {
        if (!this.contextProviders.isEmpty()) {
            ArrayList<ContextProvider> done = new ArrayList<ContextProvider>();
            for (ContextProvider provider : this.contextProviders) {
                try {
                    this.context.putAll(provider.getContext());
                    done.add(provider);
                    log.debug((Object)(provider.getClass().getCanonicalName() + " : done"));
                }
                catch (Exception e) {
                    log.debug((Object)"ContextProvider not ready -- ", (Throwable)e);
                }
            }
            this.contextProviders.removeAll(done);
            log.debug(this.context);
        }
    }

    @Override
    public Object get(String key) {
        this.prime();
        return this.context.get(key);
    }

    @Override
    public Map getAll() {
        this.prime();
        HashMap<String, Object> obj = new HashMap<String, Object>();
        obj.putAll(this.context);
        return obj;
    }

    @Override
    public boolean provides(String key) {
        this.prime();
        return this.context.containsKey(key);
    }

    @Override
    public boolean provides(Collection<String> keys) {
        this.prime();
        return this.context.keySet().containsAll(keys);
    }

    @Override
    @Autowired(required=false)
    public void setContextProviders(Collection<ContextProvider> providers) {
        this.contextProviders.addAll(providers);
        this.prime();
    }

    @Override
    public String toString() {
        ArrayList<String> outList = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : this.context.entrySet()) {
            outList.add(entry.getKey() + "=" + entry.getValue().toString());
        }
        String out = StringUtils.collectionToDelimitedString(outList, (String)",", (String)"[", (String)"]");
        return out;
    }
}

