/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.contacts.control;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.contacts.domains.ContactDomain;
import org.jasig.portlet.contacts.model.Contact;
import org.jasig.portlet.contacts.model.ContactSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class AutoCompleteController {
    private static Log log = LogFactory.getLog(AutoCompleteController.class);
    private Set<ContactDomain> contactDomains;

    @ModelAttribute(value="domain")
    public ContactDomain getDomain(@RequestParam(value="domain") String domain) {
        for (ContactDomain domainObj : this.contactDomains) {
            if (!domainObj.getId().equals(domain)) continue;
            return domainObj;
        }
        return null;
    }

    @ResourceMapping(value="autocomplete")
    public String searchDomain(ResourceRequest request, ResourceResponse response, @RequestParam(value="term") String term, @RequestParam(value="filter", required=false) String filter, @ModelAttribute(value="domain") ContactDomain domainObj, Model model) {
        log.debug((Object)("filter is " + filter));
        log.debug((Object)("q is " + term));
        ContactSet contacts = domainObj.search(term, filter);
        Map<String, Integer> countedResults = this.getCountedSearchResults(contacts);
        if (countedResults.size() > 0) {
            ArrayList data = new ArrayList();
            for (String key : countedResults.keySet()) {
                HashMap<String, String> entry = new HashMap<String, String>();
                if (countedResults.get(key) > 1) {
                    entry.put("label", "<span>" + countedResults.get(key) + " results</span>" + key);
                } else {
                    entry.put("label", key);
                }
                entry.put("value", key);
                data.add(entry);
            }
            model.addAttribute("data", (Object)data.toArray());
        }
        return "JSONView";
    }

    private Map<String, Integer> getCountedSearchResults(ContactSet results) {
        LinkedHashMap<String, Integer> countedResults = new LinkedHashMap<String, Integer>();
        for (Contact contact : results) {
            String value = contact.getFirstname() + " " + contact.getSurname();
            Integer count = (Integer)countedResults.get(value);
            if (count == null) {
                count = 0;
            }
            count = count + 1;
            countedResults.put(value, count);
        }
        return countedResults;
    }

    @Autowired
    public void setContactDomains(Set<ContactDomain> domains) {
        this.contactDomains = domains;
    }
}

