/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.contacts.adapters.impl.ldap;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.jasig.portlet.contacts.model.Address;
import org.jasig.portlet.contacts.model.Contact;
import org.jasig.portlet.contacts.model.EmailAddress;
import org.jasig.portlet.contacts.model.ModelObjectFactory;
import org.jasig.portlet.contacts.model.PhoneNumber;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.util.StringUtils;

public class ConfigurableContactAttributesMapper
implements AttributesMapper {
    Map<String, Object> config;
    ModelObjectFactory factory;

    public ConfigurableContactAttributesMapper(Map<String, Object> config, ModelObjectFactory factory) {
        this.config = config;
        this.factory = factory;
    }

    public Object mapFromAttributes(Attributes attrs) throws NamingException {
        Contact contact = (Contact)this.factory.getObjectOfType(Contact.class);
        for (String key : this.config.keySet()) {
            if (key.equalsIgnoreCase("address")) {
                Address addr = (Address)this.populate(Address.class, (Map)this.config.get(key), attrs);
                if (addr == null) continue;
                contact.getAddresses().add(addr);
                continue;
            }
            if (key.equalsIgnoreCase("phone")) {
                PhoneNumber phone = (PhoneNumber)this.populate(PhoneNumber.class, (Map)this.config.get(key), attrs);
                if (phone == null) continue;
                contact.getPhoneNumbers().add(phone);
                continue;
            }
            if (key.equalsIgnoreCase("email")) {
                EmailAddress email = (EmailAddress)this.populate(EmailAddress.class, (Map)this.config.get(key), attrs);
                if (email == null) continue;
                contact.getEmailAddresses().add(email);
                continue;
            }
            try {
                String method = "set" + StringUtils.capitalize((String)key);
                Contact.class.getMethod(method, String.class).invoke((Object)contact, attrs.get((String)this.config.get(key)));
            }
            catch (Exception ex) {
                Logger.getLogger(ConfigurableContactAttributesMapper.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return contact;
    }

    private <T> T populate(Class<T> clazz, Map<String, String> conf, Attributes attrs) {
        Object obj = this.factory.getObjectOfType(clazz);
        for (String key : conf.keySet()) {
            try {
                String method = "set" + StringUtils.capitalize((String)key);
                obj.getClass().getMethod(key, String.class).invoke(obj, this.getValue(attrs.get((String)this.config.get(key))));
            }
            catch (Exception ex) {
                Logger.getLogger(ConfigurableContactAttributesMapper.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return (T)obj;
    }

    private String getValue(Attribute attribute) throws NamingException {
        String value;
        if (attribute != null && (value = (String)attribute.get()) != null && !value.equalsIgnoreCase("empty")) {
            return value;
        }
        return "";
    }
}

