/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.contacts.control;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.contacts.domains.ContactDomain;
import org.jasig.portlet.contacts.model.Contact;
import org.jasig.portlet.contacts.model.ContactSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class DeleteContactController {
    private static Log log = LogFactory.getLog(DeleteContactController.class);
    private Set<ContactDomain> contactDomains;

    @ResourceMapping(value="delete")
    public String persist(ResourceRequest request, ResourceResponse response, @RequestParam(value="domain") String domain, @RequestParam(value="source") String source, @RequestParam(value="contact") String contact, Map<String, Object> model) throws IOException {
        log.debug((Object)"PERSIST --  START");
        log.debug((Object)("DOMAIN :: " + domain));
        log.debug((Object)("SOURCE :: " + source));
        log.debug((Object)("CONTACT :: " + contact));
        boolean removed = false;
        for (ContactDomain domainObj : this.contactDomains) {
            if (!domainObj.getId().equals(domain)) continue;
            log.debug((Object)("Found domain :: " + domainObj.getId() + " == " + domain));
            Contact toRemove = null;
            ContactSet contacts = new ContactSet();
            if (source.equalsIgnoreCase("search")) {
                String[] tokens = contact.split(":");
                String search = tokens[2];
                String filter = tokens[3];
                contacts.addAll(domainObj.search(search, filter));
            } else if (source.startsWith("urn:")) {
                contacts.add(domainObj.getContact(source));
            } else {
                contacts.addAll(domainObj.getContacts(source));
            }
            log.debug((Object)(contacts.size() + " CONTACTS to search through"));
            for (Contact contactObj : contacts) {
                log.debug((Object)("CONTACT :: " + contact + " == " + contactObj.getURN() + " :: " + contact.equalsIgnoreCase(contactObj.getURN())));
                if (!contact.equalsIgnoreCase(contactObj.getURN())) continue;
                toRemove = contactObj;
            }
            if (toRemove == null) break;
            removed = domainObj.delete(toRemove);
            break;
        }
        model.put("STATUS", "OK");
        log.debug((Object)("DELETE :: " + removed));
        model.put("deleted", removed);
        log.debug((Object)"PERSIST --  END");
        return "JSONView";
    }

    @Autowired
    public void setContactDomains(Set<ContactDomain> domains) {
        this.contactDomains = domains;
    }
}

