/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.contacts.control;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.contacts.IViewSelector;
import org.jasig.portlet.contacts.domains.ContactDomain;
import org.jasig.portlet.contacts.model.Contact;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class PortletViewController {
    private static Log log = LogFactory.getLog(PortletViewController.class);
    @Value(value="${appversion}")
    private String version;
    private Set<ContactDomain> contactDomains;
    private IViewSelector viewSelector;

    public void setVersionString(String v) {
        this.version = v;
    }

    @ModelAttribute(value="domains")
    public Set<ContactDomain> getDomains(PortletPreferences prefs) {
        log.debug((Object)"finding Domains to return");
        final List<String> domainActive = Arrays.asList(prefs.getValues("domainsActive", new String[0]));
        String[] defaultOn = prefs.getValues("defaultOn", new String[0]);
        String[] userOn = prefs.getValues("domainOn", new String[0]);
        String[] userOff = prefs.getValues("domainOff", new String[0]);
        HashSet<String> domains = new HashSet<String>();
        domains.addAll(Arrays.asList(defaultOn));
        domains.addAll(Arrays.asList(userOn));
        domains.removeAll(Arrays.asList(userOff));
        domains.retainAll(domainActive);
        TreeSet<ContactDomain> activeDomains = new TreeSet<ContactDomain>(new Comparator<ContactDomain>(){

            @Override
            public int compare(ContactDomain o1, ContactDomain o2) {
                int index1 = domainActive.indexOf(o1.getName());
                int index2 = domainActive.indexOf(o2.getName());
                return index1 - index2;
            }
        });
        for (ContactDomain domain : this.contactDomains) {
            if (!domains.contains(domain.getName())) continue;
            activeDomains.add(domain);
        }
        log.debug((Object)("returning " + activeDomains.size() + "domains"));
        return activeDomains;
    }

    @ModelAttribute(value="appversion")
    public String getAppversion() {
        return this.version;
    }

    @RequestMapping
    public String defaultView(PortletRequest req, RenderResponse response, PortletSession session, @ModelAttribute(value="domains") Set<ContactDomain> domains, Model model) {
        String urn = req.getParameter("urn");
        String domain = req.getParameter("domain");
        if (domain != null && urn != null) {
            Contact contact = null;
            model.addAttribute("activeDomain", (Object)domain);
            for (ContactDomain dom : domains) {
                if (!dom.getId().equals(domain)) continue;
                contact = dom.getContact(urn);
                break;
            }
            if (contact != null) {
                model.addAttribute("selectedContact", contact);
            }
        }
        if (urn != null) {
            log.debug((Object)urn);
        }
        if (this.viewSelector.isMobile(req)) {
            return "defaultMobileView-jQM";
        }
        return "defaultView";
    }

    @Autowired
    public void setContactDomains(Set<ContactDomain> domains) {
        this.contactDomains = domains;
    }

    @Autowired(required=true)
    public void setViewSelector(IViewSelector viewSelector) {
        this.viewSelector = viewSelector;
    }
}

