/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.contacts.control;

import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.contacts.IViewSelector;
import org.jasig.portlet.contacts.domains.ContactDomain;
import org.jasig.portlet.contacts.model.ContactSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;
import org.springframework.web.util.UriUtils;

@Controller
@RequestMapping(value={"VIEW"})
public class SetViewController {
    private static Log log = LogFactory.getLog(SetViewController.class);
    private Set<ContactDomain> contactDomains;
    private IViewSelector viewSelector;

    @ModelAttribute(value="nspace")
    public String setNspace(@RequestParam(value="nspace") String nspace) {
        return nspace;
    }

    @ModelAttribute(value="domain")
    public ContactDomain getDomain(@RequestParam(value="domain") String domain) {
        for (ContactDomain domainObj : this.contactDomains) {
            if (!domainObj.getId().equals(domain)) continue;
            return domainObj;
        }
        return null;
    }

    @ResourceMapping(value="setView")
    public String showDomain(ResourceRequest request, ResourceResponse response, @RequestParam(value="set") String setId, @ModelAttribute(value="domain") ContactDomain domainObj, Model model, PortletSession session) throws IOException {
        setId = UriUtils.decode((String)setId, (String)"UTF-8");
        ContactSet contacts = domainObj.getContacts(setId);
        model.addAttribute("contactList", (Object)contacts);
        if (domainObj.getHasPersist()) {
            model.addAttribute("persist", (Object)true);
        }
        log.debug((Object)(contacts.size() + " CONTACTS found for " + contacts.getTitle()));
        log.debug((Object)("Contacts set for domain :: " + domainObj.getName()));
        model.addAttribute("source", (Object)setId);
        model.addAttribute("domain", (Object)domainObj);
        model.addAttribute("source", (Object)setId);
        if (this.viewSelector.isMobile((PortletRequest)request)) {
            return "setView-jQM";
        }
        return "setView";
    }

    @ResourceMapping(value="search")
    public String searchDomain(ResourceRequest request, ResourceResponse response, PortletSession session, @RequestParam(value="term") String term, @RequestParam(value="filter") String filter, @ModelAttribute(value="domain") ContactDomain domainObj, Model model) throws IOException {
        ContactSet contacts = new ContactSet();
        if (!term.trim().equals("")) {
            model.addAttribute("domain", (Object)domainObj);
            model.addAttribute("source", (Object)"search");
            contacts.addAll((Collection)domainObj.search(term, filter));
            log.debug((Object)(contacts.size() + " CONTACTS found for " + contacts.getTitle()));
            log.debug((Object)("Contacts set for domain :: " + domainObj.getName()));
        }
        model.addAttribute("contactList", (Object)contacts);
        if (this.viewSelector.isMobile((PortletRequest)request)) {
            return "setView-jQM";
        }
        return "setView";
    }

    @Autowired
    public void setContactDomains(Set<ContactDomain> domains) {
        this.contactDomains = domains;
    }

    @Autowired(required=true)
    public void setViewSelector(IViewSelector viewSelector) {
        this.viewSelector = viewSelector;
    }
}

