/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.contacts.control;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletModeException;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.contacts.control.util.DomainMap;
import org.jasig.portlet.contacts.domains.ContactDomain;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.SessionAttributes;

@Controller
@RequestMapping(value={"EDIT"})
@SessionAttributes(value={"domains"})
public class PortletEditController {
    private static Log log = LogFactory.getLog(PortletEditController.class);
    private Set<ContactDomain> contactDomains;

    @ModelAttribute(value="domains")
    public DomainMap getDomains(PortletPreferences prefs) {
        List<String> domainActive = Arrays.asList(prefs.getValues("domainsActive", new String[0]));
        String[] defaultOn = prefs.getValues("defaultOn", new String[0]);
        String[] userOn = prefs.getValues("domainOn", new String[0]);
        String[] userOff = prefs.getValues("domainOff", new String[0]);
        HashSet<String> domains = new HashSet<String>();
        domains.addAll(Arrays.asList(defaultOn));
        domains.addAll(Arrays.asList(userOn));
        domains.removeAll(Arrays.asList(userOff));
        domains.retainAll(domainActive);
        TreeMap<String, Boolean> domainsMap = new TreeMap<String, Boolean>();
        for (ContactDomain domain : this.contactDomains) {
            if (domains.contains(domain.getName())) {
                domainsMap.put(domain.getName(), true);
                continue;
            }
            domainsMap.put(domain.getName(), false);
        }
        return new DomainMap(domainsMap);
    }

    @RequestMapping(method={RequestMethod.POST})
    public void changeConfig(@ModelAttribute(value="domains") DomainMap domainMap, BindingResult result, ActionRequest request, ActionResponse response) throws PortletModeException, IOException {
        PortletPreferences prefs = request.getPreferences();
        ArrayList<String> domainOff = new ArrayList<String>();
        ArrayList<String> domainOn = new ArrayList<String>();
        for (String search : domainMap.getMap().keySet()) {
            if (domainMap.getMap().get(search).booleanValue()) {
                domainOn.add(search);
                continue;
            }
            domainOff.add(search);
        }
        try {
            prefs.setValues("domainOn", domainOn.toArray(new String[0]));
            prefs.setValues("domainOff", domainOff.toArray(new String[0]));
            prefs.store();
            response.setRenderParameter("saveStatus", "success");
        }
        catch (Exception ex) {
            log.error((Object)"Failed to save user Prefs", (Throwable)ex);
        }
    }

    @RequestMapping
    public String showEditView(RenderRequest request, Model model) {
        model.addAttribute("saved", (Object)(request.getParameter("saveStatus") != null ? 1 : 0));
        return "edit";
    }

    @Autowired
    public void setContactDomains(Set<ContactDomain> domains) {
        this.contactDomains = domains;
    }
}

