/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.contacts.adapters.impl.ldap;

import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.contacts.model.Address;
import org.jasig.portlet.contacts.model.Contact;
import org.jasig.portlet.contacts.model.EmailAddress;
import org.jasig.portlet.contacts.model.ModelObjectFactory;
import org.jasig.portlet.contacts.model.PhoneNumber;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.util.StringUtils;

public class ConfigurableContactAttributesMapper
implements AttributesMapper {
    static final Log logger = LogFactory.getLog(ConfigurableContactAttributesMapper.class);
    String defaultPrefix = "$default:";
    Map<String, Object> config;
    ModelObjectFactory factory;

    public ConfigurableContactAttributesMapper(Map<String, Object> config, ModelObjectFactory factory) {
        this.config = config;
        this.factory = factory;
    }

    public void setDefaultPrefix(String defaultPrefix) {
        this.defaultPrefix = defaultPrefix;
    }

    public Object mapFromAttributes(Attributes attrs) {
        Contact contact = this.factory.getObjectOfType(Contact.class);
        for (String propertyName : this.config.keySet()) {
            if (propertyName.equalsIgnoreCase("address")) {
                List addressMappings = (List)this.config.get(propertyName);
                for (Map addressMap : addressMappings) {
                    Address addr = this.populate(Address.class, addressMap, attrs);
                    if (!addr.isPopulated()) continue;
                    contact.getAddresses().add(addr);
                }
                continue;
            }
            if (propertyName.equalsIgnoreCase("phone")) {
                List phoneMappings = (List)this.config.get(propertyName);
                for (Map phoneMap : phoneMappings) {
                    PhoneNumber phone = this.populate(PhoneNumber.class, phoneMap, attrs);
                    if (!phone.isPopulated()) continue;
                    contact.getPhoneNumbers().add(phone);
                }
                continue;
            }
            if (propertyName.equalsIgnoreCase("email")) {
                List emailMappings = (List)this.config.get(propertyName);
                for (Map emailMap : emailMappings) {
                    EmailAddress email = this.populate(EmailAddress.class, emailMap, attrs);
                    if (!email.isPopulated()) continue;
                    contact.getEmailAddresses().add(email);
                }
                continue;
            }
            this.setProperty(contact, propertyName, this.config, attrs);
        }
        return contact;
    }

    private <T> T populate(Class<T> clazz, Map<String, String> propertyToLDAPNameMap, Attributes attrs) {
        T obj = this.factory.getObjectOfType(clazz);
        for (String propertyName : propertyToLDAPNameMap.keySet()) {
            this.setProperty(obj, propertyName, propertyToLDAPNameMap, attrs);
        }
        return obj;
    }

    private <T> void setProperty(T obj, String propertyName, Map<String, ?> propertyNameToLDAPNameMap, Attributes attrs) {
        String method = "set" + StringUtils.capitalize((String)propertyName);
        String ldapAttributeName = (String)propertyNameToLDAPNameMap.get(propertyName);
        try {
            if (StringUtils.hasLength((String)ldapAttributeName)) {
                if (ldapAttributeName.startsWith(this.defaultPrefix)) {
                    obj.getClass().getMethod(method, String.class).invoke(obj, ldapAttributeName.substring(this.defaultPrefix.length()));
                } else {
                    Attribute attr = attrs.get(ldapAttributeName);
                    obj.getClass().getMethod(method, String.class).invoke(obj, this.getValue(attr));
                    if (attr != null && attr.size() > 1) {
                        logger.warn((Object)("Found multiple values for LDAP attribute " + ldapAttributeName + attrs.get("cn") != null ? ", cn=" + this.config.get("cn") : ""));
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Exception setting property for " + obj.getClass().getCanonicalName() + "." + method + ", LDAP attribute " + ldapAttributeName), (Throwable)ex);
        }
    }

    private String getValue(Attribute attribute) throws NamingException {
        String value;
        if (attribute != null && (value = (String)attribute.get()) != null && !value.equalsIgnoreCase("empty")) {
            return value;
        }
        return "";
    }
}

