/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.contacts.domains.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.contacts.adapters.PersistAdapter;
import org.jasig.portlet.contacts.adapters.PushAdapter;
import org.jasig.portlet.contacts.adapters.RemoveAdapter;
import org.jasig.portlet.contacts.adapters.SearchAdapter;
import org.jasig.portlet.contacts.context.ContactContext;
import org.jasig.portlet.contacts.decorators.ContactDecorator;
import org.jasig.portlet.contacts.decorators.impl.PassThroughContactDecorator;
import org.jasig.portlet.contacts.domains.ContactDomain;
import org.jasig.portlet.contacts.model.Contact;
import org.jasig.portlet.contacts.model.ContactSet;
import org.jasig.portlet.contacts.model.util.ContactSetComparator;
import org.springframework.beans.factory.annotation.Autowired;

public class GenericContactDomain
implements ContactDomain {
    private static Log log = LogFactory.getLog(GenericContactDomain.class);
    private String name;
    private String id = null;
    private boolean canDelete = false;
    private boolean canSave = false;
    private SearchAdapter searchAdapter = null;
    private PushAdapter pushAdapter = null;
    private PersistAdapter persistAdapter = null;
    private RemoveAdapter removeAdapter = null;
    private ContactContext context = null;
    private ContactDecorator decorator = new PassThroughContactDecorator();

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setSearchAdapter(SearchAdapter search) {
        this.searchAdapter = search;
    }

    @Override
    public void setPushAdapter(PushAdapter push) {
        this.pushAdapter = push;
    }

    @Override
    public void setPersistAdapter(PersistAdapter persist) {
        this.persistAdapter = persist;
    }

    @Override
    public void setRemoveAdapter(RemoveAdapter remove) {
        this.removeAdapter = remove;
    }

    @Override
    @Autowired
    public void setContext(ContactContext context) {
        this.context = context;
    }

    @Override
    public boolean getHasSearch() {
        return this.searchAdapter != null;
    }

    @Override
    public boolean getHasPush() {
        return this.pushAdapter != null;
    }

    @Override
    public boolean getHasPersist() {
        return this.persistAdapter != null;
    }

    @Override
    public boolean getHasRemove() {
        return this.removeAdapter != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        if (this.id == null) {
            return this.name.replace(" ", "");
        }
        return this.id;
    }

    @Override
    public ContactContext getContext() {
        return this.context;
    }

    @Override
    public ContactSet search(String searchText) {
        ContactSet results = this.getHasSearch() ? this.searchAdapter.search(searchText) : new ContactSet();
        this.decorator.decorate(results);
        return results;
    }

    @Override
    public ContactSet search(String searchText, String filter) {
        ContactSet results = this.getHasSearch() ? this.searchAdapter.search(searchText, filter) : new ContactSet();
        this.decorator.decorate(results);
        return results;
    }

    @Override
    public Set<ContactSet> getContacts() {
        Set<ContactSet> results = this.getHasPush() ? this.pushAdapter.getContacts() : new TreeSet<ContactSet>(new ContactSetComparator());
        for (ContactSet set : results) {
            this.decorator.decorate(set);
        }
        return results;
    }

    @Override
    public ContactSet getContacts(String setId) {
        ContactSet result;
        if (this.getHasPush()) {
            result = this.pushAdapter.getContacts(setId);
            this.decorator.decorate(result);
        } else {
            result = new ContactSet();
        }
        return result;
    }

    @Override
    public Contact getContact(String URN) {
        Contact contact = null;
        if (this.getHasSearch()) {
            contact = this.searchAdapter.getByURN(URN);
        }
        if (contact == null && this.getHasPush()) {
            contact = this.pushAdapter.getByURN(URN);
        }
        if (contact != null) {
            this.decorator.decorate(contact);
        }
        return contact;
    }

    @Override
    public Map<String, String> getContactGroups() {
        TreeMap<String, String> groups = new TreeMap<String, String>();
        if (this.getHasPush()) {
            groups.putAll(this.pushAdapter.getGroups());
        }
        return groups;
    }

    @Override
    public List<String> getSearchFilters() {
        ArrayList<String> filters = new ArrayList<String>();
        if (this.getHasSearch()) {
            filters.addAll(this.searchAdapter.getFilters().keySet());
        }
        return filters;
    }

    @Override
    public boolean save(Contact contact) {
        if (this.getHasPersist()) {
            log.debug((Object)"Passing to Persist adapter");
            return this.persistAdapter.save(contact);
        }
        log.debug((Object)"No Persist adapter for domain");
        return false;
    }

    @Override
    public boolean delete(Contact contact) {
        if (this.getHasRemove()) {
            log.debug((Object)"Passing to Remove adapter");
            return this.removeAdapter.delete(contact);
        }
        log.debug((Object)"No Remove adapter for domain");
        return false;
    }

    @Override
    public void setDecorator(ContactDecorator decorator) {
        this.decorator = decorator;
    }

    public String toString() {
        return this.getId() + "::" + this.getName();
    }
}

