/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.contacts.context.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.contacts.context.ContactContext;
import org.jasig.portlet.contacts.context.ContextProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class ContactContextImpl
implements ContactContext {
    private static Log log = LogFactory.getLog(ContactContextImpl.class);
    private Map<String, Object> context = new HashMap();
    private final List<ContextProvider> contextProviders = new ArrayList();

    public Object get(String key) {
        Object out = null;
        for (ContextProvider provider : this.contextProviders) {
            if (!provider.provides(key)) continue;
            out = provider.get(key);
            break;
        }
        return out;
    }

    public Map getAll() {
        HashMap obj = new HashMap();
        for (ContextProvider provider : this.contextProviders) {
            try {
                obj.putAll(provider.getContext());
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
        }
        return obj;
    }

    public boolean provides(String key) {
        log.debug((Object)this.toString());
        for (ContextProvider provider : this.contextProviders) {
            if (!provider.provides(key)) continue;
            return true;
        }
        return false;
    }

    public boolean provides(Collection<String> keys) {
        log.debug((Object)this.toString());
        ArrayList<String> keyList = new ArrayList<String>();
        keyList.addAll(keys);
        for (ContextProvider provider : this.contextProviders) {
            keyList.removeAll(provider.keySet());
        }
        return keyList.isEmpty();
    }

    @Autowired(required=true)
    public void setContextProviders(Collection<ContextProvider> providers) {
        this.contextProviders.addAll(providers);
    }

    public String toString() {
        ArrayList<String> outList = new ArrayList<String>();
        for (ContextProvider prov : this.contextProviders) {
            for (Map.Entry entry : prov.getContext().entrySet()) {
                outList.add(entry.getKey() + "=" + entry.getValue());
            }
        }
        String out = StringUtils.collectionToDelimitedString(outList, (String)",", (String)"[", (String)"]");
        return out;
    }
}

