/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.contacts.adapters.impl.ldap;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.Name;
import javax.naming.directory.SearchControls;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.contacts.adapters.impl.AbstractSearchAdapter;
import org.jasig.portlet.contacts.model.Contact;
import org.jasig.portlet.contacts.model.ContactSet;
import org.jasig.portlet.contacts.model.ModelObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.CompareFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.OrFilter;
import org.springframework.ldap.filter.WhitespaceWildcardsFilter;
import org.springframework.util.StringUtils;

public class LdapSearchAdapter
extends AbstractSearchAdapter {
    private static Log logger = LogFactory.getLog(LdapSearchAdapter.class);
    private int timeLimit = 1000;
    private int countLimit = 0;
    private LdapTemplate ldapTemplate;
    private String searchAttribute = "cn";
    private String filterAttribute = "employeeType";
    private Set<CompareFilter> ldapSearchFilter = new HashSet<CompareFilter>();
    private ModelObjectFactory modelFactory;
    private AttributesMapper contactMapper;

    public LdapSearchAdapter(LdapTemplate ldapTemplate) {
        this.ldapTemplate = ldapTemplate;
    }

    public void setLdapSearchFilters(Set<CompareFilter> filter) {
        this.ldapSearchFilter = filter;
    }

    public void setTimeLimit(int timeLimit) {
        this.timeLimit = timeLimit;
    }

    public void setCountLimit(int countLimit) {
        this.countLimit = countLimit;
    }

    public void setSearchAttribute(String searchAttribute) {
        this.searchAttribute = searchAttribute;
    }

    @Override
    public void setFilterAttribute(String filterAttribute) {
        this.filterAttribute = filterAttribute;
    }

    @Override
    public Contact getByURN(String urn) {
        String[] attr = StringUtils.delimitedListToStringArray((String)urn, (String)":");
        String searchText = attr[2];
        String filter = attr[3];
        String id = attr[4];
        ContactSet contacts = this.search(searchText, filter);
        for (Contact contact : contacts) {
            if (!contact.getId().equals(id)) continue;
            return contact;
        }
        return null;
    }

    @Override
    public ContactSet search(String searchText) {
        return this.search(searchText, null);
    }

    @Override
    public ContactSet search(String searchText, String filter) {
        String searchString = this.constructSearch(searchText, filter);
        if (filter == null) {
            filter = "";
        }
        List<Contact> contactList = this.getSearchResults(searchString);
        ContactSet contactSet = new ContactSet();
        contactSet.setId(searchText + ":" + filter);
        contactSet.setTitle("Search Results");
        for (Contact contact : contactList) {
            contact.setContactSource("search:" + searchText + ":" + filter);
            contactSet.add(contact);
        }
        return contactSet;
    }

    protected String constructSearch(String searchValue, String searchFilter) {
        AndFilter andFilter = new AndFilter();
        andFilter.and((Filter)new EqualsFilter("objectclass", "person"));
        andFilter.and((Filter)new WhitespaceWildcardsFilter(this.searchAttribute, searchValue));
        for (CompareFilter filter : this.ldapSearchFilter) {
            andFilter.and((Filter)filter);
        }
        logger.debug((Object)("SEARCH CONSTRUCT :: " + searchValue + " :: " + searchFilter));
        if (this.filters != null && searchFilter != null) {
            List filter = (List)this.filters.get(searchFilter);
            logger.debug((Object)"FILTERS");
            if (filter != null && filter.size() != 0) {
                logger.debug((Object)("Constructing " + searchFilter + " search"));
                OrFilter orFilter = new OrFilter();
                for (String filterValue : filter) {
                    orFilter.or((Filter)new EqualsFilter(this.filterAttribute, filterValue));
                }
                andFilter.and((Filter)orFilter);
            }
        }
        return andFilter.toString();
    }

    protected List<Contact> getSearchResults(String search) {
        SearchControls searchControls = this.getSearchControls();
        logger.debug((Object)("Searching LDAP with search: " + search));
        List contactList = this.ldapTemplate.search((Name)DistinguishedName.EMPTY_PATH, search, searchControls, this.contactMapper);
        return contactList;
    }

    protected SearchControls getSearchControls() {
        SearchControls searchControls = new SearchControls();
        searchControls.setTimeLimit(this.timeLimit);
        searchControls.setCountLimit(this.countLimit);
        searchControls.setSearchScope(2);
        return searchControls;
    }

    @Override
    protected String[] requiredAttributes() {
        return new String[0];
    }

    @Autowired
    public void setModelObjectFactory(ModelObjectFactory factory) {
        this.modelFactory = factory;
    }

    public void setAttributesMapper(AttributesMapper contactMapper) {
        this.contactMapper = contactMapper;
    }
}

