/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.contacts.control;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;
import javax.portlet.Event;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.WindowState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.search.PortletUrl;
import org.jasig.portal.search.PortletUrlParameter;
import org.jasig.portal.search.SearchConstants;
import org.jasig.portal.search.SearchRequest;
import org.jasig.portal.search.SearchResult;
import org.jasig.portal.search.SearchResults;
import org.jasig.portlet.contacts.domains.ContactDomain;
import org.jasig.portlet.contacts.model.Contact;
import org.jasig.portlet.contacts.model.ContactSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.annotation.EventMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class SearchEventController {
    private static Log log = LogFactory.getLog(SearchEventController.class);
    private Set<ContactDomain> contactDomains;

    @EventMapping(value="{https://source.jasig.org/schemas/uportal/search}SearchRequest")
    public void handleSearchEvents(EventRequest request, EventResponse response) {
        log.debug((Object)"Responding to Search Event");
        Event event = request.getEvent();
        SearchRequest searchQuery = (SearchRequest)event.getValue();
        String searchTerms = searchQuery.getSearchTerms();
        SearchResults searchResults = new SearchResults();
        searchResults.setQueryId(searchQuery.getQueryId());
        searchResults.setWindowId(request.getWindowID());
        for (ContactDomain domain : this.contactDomains) {
            if (!domain.getHasSearch()) continue;
            ContactSet contacts = domain.search(searchTerms);
            for (Contact contact : contacts) {
                SearchResult searchResult = new SearchResult();
                String title = contact.getSurname().toUpperCase() + ", " + contact.getTitle() + " " + contact.getFirstname();
                if (contact.getPosition() != null && !contact.getPosition().equals("")) {
                    title = title + " (" + contact.getPosition() + ")";
                }
                ArrayList<String> summary = new ArrayList<String>();
                if (contact.getPrimaryEmailAddress() != null) {
                    summary.add("E:" + contact.getPrimaryEmailAddress().getEmailAddress());
                }
                if (contact.getPrimaryPhoneNumber() != null) {
                    summary.add("T:" + contact.getPrimaryPhoneNumber().getPhoneNumber());
                }
                String summaryText = StringUtils.collectionToDelimitedString(summary, (String)" -- ");
                searchResult.setTitle(title);
                searchResult.setSummary(summaryText);
                PortletUrl url = new PortletUrl();
                url.setPortletMode("VIEW");
                url.setWindowState(WindowState.MAXIMIZED.toString());
                PortletUrlParameter domainParam = new PortletUrlParameter();
                domainParam.setName("domain");
                domainParam.getValue().add(domain.getId());
                url.getParam().add(domainParam);
                PortletUrlParameter urnParam = new PortletUrlParameter();
                urnParam.setName("urn");
                urnParam.getValue().add(contact.getURN());
                url.getParam().add(urnParam);
                searchResult.setPortletUrl(url);
                searchResult.getType().add("contact");
                searchResults.getSearchResult().add(searchResult);
            }
        }
        response.setEvent(SearchConstants.SEARCH_RESULTS_QNAME, (Serializable)searchResults);
        log.debug((Object)("Finished response -- " + searchResults.getSearchResult().size() + " -- results returned"));
    }

    @Autowired
    public void setContactDomains(Set<ContactDomain> domains) {
        this.contactDomains = domains;
    }
}

