/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.contacts.control;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import javax.portlet.RenderRequest;
import javax.portlet.ValidatorException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.contacts.control.util.DomainMap;
import org.jasig.portlet.contacts.domains.ContactDomain;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"CONFIG"})
public class ConfigController {
    private static Log log = LogFactory.getLog(ConfigController.class);
    private Set<ContactDomain> contactDomains;

    @ModelAttribute(value="domainsActive")
    public DomainMap getActiveDomains(PortletPreferences prefs) {
        List<String> domainActive = Arrays.asList(prefs.getValues("domainsActive", new String[0]));
        TreeMap<String, Boolean> domainsMap = new TreeMap<String, Boolean>();
        for (ContactDomain domain : this.contactDomains) {
            if (domainActive.contains(domain.getName())) {
                domainsMap.put(domain.getName(), true);
                continue;
            }
            domainsMap.put(domain.getName(), false);
        }
        return new DomainMap(domainsMap);
    }

    @ModelAttribute(value="domainsDefault")
    public DomainMap getDefaultDomains(PortletPreferences prefs) {
        List<String> domainActive = Arrays.asList(prefs.getValues("domainsActive", new String[0]));
        List<String> defaultOn = Arrays.asList(prefs.getValues("defaultOn", new String[0]));
        TreeMap<String, Boolean> domainsMap = new TreeMap<String, Boolean>();
        for (String domain : domainActive) {
            if (defaultOn.contains(domain)) {
                domainsMap.put(domain, true);
                continue;
            }
            domainsMap.put(domain, false);
        }
        return new DomainMap(domainsMap);
    }

    @ActionMapping(params={"action=active"})
    public void setActiveDomains(ActionRequest request, ActionResponse response, PortletPreferences prefs, @ModelAttribute(value="domainsActive") DomainMap domains, BindingResult result) throws ReadOnlyException, IOException, ValidatorException {
        log.debug((Object)"activate");
        ArrayList domainActive = new ArrayList();
        for (Map.Entry entry : domains.getMap().entrySet()) {
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            domainActive.add(entry.getKey());
        }
        prefs.setValues("domainsActive", domainActive.toArray(new String[0]));
        prefs.store();
        response.setRenderParameter("activeSaved", "true");
    }

    @ActionMapping(params={"action=default"})
    public void setDefaultDomains(ActionRequest request, ActionResponse response, PortletPreferences prefs, @ModelAttribute(value="domainsDefault") DomainMap domains, BindingResult result) throws ReadOnlyException, IOException, ValidatorException {
        log.debug((Object)"default");
        ArrayList defaultOn = new ArrayList();
        for (Map.Entry entry : domains.getMap().entrySet()) {
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            defaultOn.add(entry.getKey());
        }
        prefs.setValues("defaultOn", defaultOn.toArray(new String[0]));
        prefs.store();
        response.setRenderParameter("defaultSaved", "true");
    }

    @RenderMapping
    public String defaultView(Model model, RenderRequest request) {
        log.debug((Object)"render");
        model.addAttribute("defaultSaved", (Object)(request.getParameter("defaultSaved") != null ? 1 : 0));
        model.addAttribute("activeSaved", (Object)(request.getParameter("activeSaved") != null ? 1 : 0));
        return "ConfigView";
    }

    @Autowired
    public void setContactDomains(Set<ContactDomain> domains) {
        this.contactDomains = domains;
    }
}

