/**
 * Licensed to Jasig under one or more contributor license
 * agreements. See the NOTICE file distributed with this work
 * for additional information regarding copyright ownership.
 * Jasig licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a
 * copy of the License at:
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.jasig.portlet.cms.model;

import java.io.Serializable;

import org.apache.commons.lang.builder.ToStringBuilder;

public class RepositorySearchOptions implements Serializable {
	
	private static final long serialVersionUID = 8963746618924583880L;
	private String keyword;
	
	public String getKeyword() {
		return keyword;
	}
	
	public void setKeyword(final String keyword) {
		this.keyword = keyword;
	}
	
	@Override
	public String toString() {
		final ToStringBuilder bldr = new ToStringBuilder(this);
		bldr.append("keyword", getKeyword());
		
		return bldr.toString();
	}
	
}
