/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.cms.controller;

import java.net.URLEncoder;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.cms.model.Attachment;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class DownloadPostAttachmentController
extends AbstractController {
    private final Log logger = LogFactory.getLog(this.getClass());

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        Attachment attachment = (Attachment)session.getAttribute("attachment");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Attempting to download attachment: " + attachment));
        }
        response.setContentType("application/x-download");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Set content type to: " + response.getContentType()));
        }
        String encoding = response.getCharacterEncoding();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Encoded file name based on: " + encoding));
        }
        String fileName = URLEncoder.encode(attachment.getFileName(), encoding);
        response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Downloading file: " + fileName));
        }
        ServletOutputStream out = response.getOutputStream();
        out.write(attachment.getContents());
        out.flush();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Clearing session attribute");
        }
        session.setAttribute("attachment", null);
        return null;
    }
}

