/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.cms.controller;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.cms.controller.PortletPreferencesWrapper;
import org.jasig.portlet.cms.model.Attachment;
import org.jasig.portlet.cms.model.Post;
import org.jasig.portlet.cms.model.repository.RepositoryDao;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.portlet.multipart.MultipartActionRequest;
import org.springframework.web.portlet.mvc.SimpleFormController;
import org.springframework.web.portlet.util.PortletUtils;

public class EditPostController
extends SimpleFormController {
    private final Log logger = LogFactory.getLog(this.getClass());
    private RepositoryDao repositoryDao = null;

    protected Object formBackingObject(PortletRequest request) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Preparing post for edit");
        }
        PortletPreferencesWrapper pref = new PortletPreferencesWrapper(request);
        Post post = this.getRepositoryDao().getPost(pref.getPortletRepositoryRoot());
        if (post == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"No post exists in repository. Configuring blank post");
            }
            post = new Post();
            post.setAuthor(pref.getPortletUserName());
            post.setPath(pref.getPortletRepositoryRoot());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Post: " + post));
        }
        return post;
    }

    private RepositoryDao getRepositoryDao() {
        return this.repositoryDao;
    }

    protected void onSubmitAction(ActionRequest request, ActionResponse response, Object command, BindException errors) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Received post object");
        }
        Post post = (Post)command;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Post: " + post));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Submitting post object");
        }
        this.processPostAttachments(request, post);
        this.getRepositoryDao().setPost(post);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Clearing render parameters");
        }
        PortletUtils.clearAllRenderParameters((ActionResponse)response);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Switing to view mode");
        }
        response.setPortletMode(PortletMode.VIEW);
    }

    private void processPostAttachments(ActionRequest request, Post post) throws IOException {
        MultipartActionRequest multipartRequest = (MultipartActionRequest)request;
        Collection files = multipartRequest.getFileMap().values();
        for (MultipartFile file : files) {
            if (file.isEmpty()) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Uploading attachment file: " + file.getOriginalFilename()));
                this.logger.debug((Object)("Attachment file size: " + file.getSize()));
            }
            Attachment attachment = Attachment.fromFile((String)file.getOriginalFilename(), (String)file.getContentType(), (Date)new Date(), (Locale)request.getLocale(), (byte[])file.getBytes());
            post.getAttachments().add(attachment);
        }
    }

    protected Map referenceData(PortletRequest request, Object command, Errors errors) throws Exception {
        HashMap<String, PortletPreferencesWrapper> data = new HashMap<String, PortletPreferencesWrapper>();
        PortletPreferencesWrapper pref = new PortletPreferencesWrapper(request);
        data.put("portletPreferencesWrapper", pref);
        return data;
    }

    public void setRepositoryDao(RepositoryDao repositoryDao) {
        this.repositoryDao = repositoryDao;
    }
}

