/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.cms.controller;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSecurityException;
import org.springframework.web.portlet.handler.HandlerInterceptorAdapter;

public class PortletModeUserRoleAuthorizationInterceptor
extends HandlerInterceptorAdapter {
    private Map<String, String> authorizedRolesMap = null;

    public boolean preHandle(PortletRequest request, PortletResponse response, Object handler) throws PortletException, IOException {
        boolean allowed = false;
        if (this.authorizedRolesMap != null) {
            Iterator it = this.authorizedRolesMap.entrySet().iterator();
            while (!allowed && it.hasNext()) {
                Map.Entry entry = it.next();
                PortletMode mode = new PortletMode((String)entry.getKey());
                String role = null;
                if (entry.getValue() != null) {
                    role = ((String)entry.getValue()).toString();
                }
                if (!request.getPortletMode().equals((Object)mode)) continue;
                allowed = role.length() <= 0 || role.equalsIgnoreCase("*") || request.isUserInRole(role);
            }
        } else {
            allowed = true;
        }
        if (!allowed) {
            throw new PortletSecurityException("Request not authorized");
        }
        return allowed;
    }

    public final void setAuthorizedRolesMap(Map<String, String> authorizedRolesMap) {
        this.authorizedRolesMap = authorizedRolesMap;
    }
}

