/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.cms.controller;

import java.util.List;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.cms.controller.PortletPreferencesWrapper;
import org.jasig.portlet.cms.model.Post;
import org.jasig.portlet.cms.model.security.AntiVirusService;
import org.jasig.portlet.cms.model.security.XssValidatorService;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.portlet.context.PortletRequestAttributes;

public class PostValidator
implements Validator {
    private AntiVirusService antiVirusService = null;
    private XssValidatorService xssValidatorService = null;
    private final Log logger = LogFactory.getLog(this.getClass());

    private AntiVirusService getAntiVirusService() {
        return this.antiVirusService;
    }

    private XssValidatorService getXssValidatorService() {
        return this.xssValidatorService;
    }

    public void setAntiVirusService(AntiVirusService svc) {
        this.antiVirusService = svc;
    }

    public void setXssValidatorService(XssValidatorService svc) {
        this.xssValidatorService = svc;
    }

    public boolean supports(Class arg0) {
        return Post.class.isAssignableFrom(arg0);
    }

    public void validate(Object arg0, Errors errors) {
        RequestAttributes requestAttributes;
        PortletRequest request;
        PortletPreferencesWrapper pref;
        Post post = (Post)arg0;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Validaing post content " + errors.getFieldValue("content")));
        }
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"content", (String)"invalid.post.content.empty");
        if (post.getContent().trim().isEmpty() && !errors.hasErrors()) {
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"content", (String)"invalid.post.content.empty");
        }
        if ((pref = new PortletPreferencesWrapper(request = ((PortletRequestAttributes)(requestAttributes = RequestContextHolder.currentRequestAttributes())).getRequest())).isXssValidationEnabled()) {
            this.validatePostContent(post, errors);
        }
        this.validatePostAttachments(post, errors);
        if (this.logger.isDebugEnabled()) {
            if (errors.getErrorCount() == 0) {
                this.logger.debug((Object)"Validated post successfully without errors");
            } else {
                this.logger.debug((Object)("Rejected post with " + errors.getErrorCount() + " errors"));
            }
        }
    }

    private void validatePostAttachments(Post post, Errors errors) {
        if (post.getAttachments().size() > 0) {
            this.getAntiVirusService();
        }
    }

    private void validatePostContent(Post post, Errors errors) {
        List errorList = this.getXssValidatorService().scan(post.getContent());
        if (errorList != null && errorList.size() > 0) {
            for (String err : errorList) {
                errors.rejectValue("content", "invalid.post.content.xss", (Object[])new String[]{err}, null);
            }
        }
    }
}

