/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.cms.controller;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.cms.model.Attachment;
import org.jasig.portlet.cms.model.Post;
import org.jasig.portlet.cms.model.RemovePostAttachmentResponse;
import org.jasig.portlet.cms.model.repository.RepositoryDao;
import org.jasig.web.portlet.mvc.AbstractAjaxController;
import org.springframework.web.portlet.bind.PortletRequestUtils;

public class RemovePostAttachmentAjaxController
extends AbstractAjaxController {
    private final Log logger = LogFactory.getLog(this.getClass());
    private RepositoryDao repositoryDao = null;

    private RepositoryDao getRepositoryDao() {
        return this.repositoryDao;
    }

    protected Map<String, ?> handleAjaxRequestInternal(ActionRequest request, ActionResponse resp) throws Exception {
        Post post;
        RemovePostAttachmentResponse response = new RemovePostAttachmentResponse();
        String attachmentPath = PortletRequestUtils.getRequiredStringParameter((PortletRequest)request, (String)"attachmentPath");
        String postPath = PortletRequestUtils.getRequiredStringParameter((PortletRequest)request, (String)"postPath");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Retrieving repository post at " + postPath));
            this.logger.debug((Object)("Attachment path to remove: " + attachmentPath));
        }
        if ((post = this.getRepositoryDao().getPost(postPath)) != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Retrieved repository post " + post));
            }
            Iterator it = post.getAttachments().iterator();
            Attachment attachment = null;
            while (!response.isRemoveSuccessful() && it.hasNext()) {
                attachment = (Attachment)it.next();
                if (!attachment.getPath().equals(attachmentPath)) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Removing post attachment: " + attachment));
                }
                it.remove();
                response.setRemovedAttachment(attachment);
                response.setRemoveSuccessful(true);
            }
            if (response.isRemoveSuccessful()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Saving post");
                }
                this.getRepositoryDao().setPost(post);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Saved post: " + post));
                }
            }
        }
        return Collections.singletonMap("response", response);
    }

    public void setRepositoryDao(RepositoryDao repositoryDao) {
        this.repositoryDao = repositoryDao;
    }
}

