/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.cms.controller;

import java.util.Collection;
import java.util.HashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.cms.controller.PortletPreferencesWrapper;
import org.jasig.portlet.cms.model.RepositorySearchOptions;
import org.jasig.portlet.cms.model.repository.RepositoryDao;
import org.springframework.validation.BindException;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.mvc.AbstractCommandController;
import org.springframework.web.portlet.util.PortletUtils;

public class SearchController
extends AbstractCommandController {
    private final Log logger = LogFactory.getLog(this.getClass());
    private RepositoryDao repositoryDao = null;

    private RepositoryDao geRepositoryDao() {
        return this.repositoryDao;
    }

    protected void handleAction(ActionRequest actionrequest, ActionResponse actionresponse, Object obj, BindException bindexception) throws Exception {
        PortletUtils.clearAllRenderParameters((ActionResponse)actionresponse);
    }

    protected ModelAndView handleRender(RenderRequest renderrequest, RenderResponse renderresponse, Object obj, BindException bindexception) throws Exception {
        RepositorySearchOptions options = (RepositorySearchOptions)obj;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Executing search");
        }
        Collection results = this.geRepositoryDao().search(options);
        HashMap model = new HashMap();
        if (results != null && results.size() > 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Number of search results found: " + results.size()));
            }
            model.put("searchResults", results);
            model.put("portletPreferences", new PortletPreferencesWrapper((PortletRequest)renderrequest));
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"No results are found");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Returning search results");
        }
        ModelAndView modelAndView = new ModelAndView("viewSearchResults", model);
        return modelAndView;
    }

    public void setRepositoryDao(RepositoryDao repositoryDao) {
        this.repositoryDao = repositoryDao;
    }
}

