/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.cms.controller;

import java.util.Iterator;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.cms.model.Attachment;
import org.jasig.portlet.cms.model.Post;
import org.jasig.portlet.cms.model.repository.RepositoryDao;
import org.springframework.web.portlet.bind.PortletRequestUtils;
import org.springframework.web.portlet.mvc.AbstractController;

public class ViewPostAttachmentController
extends AbstractController {
    private final Log logger = LogFactory.getLog(this.getClass());
    private RepositoryDao repositoryDao = null;

    private RepositoryDao getRepositoryDao() {
        return this.repositoryDao;
    }

    protected void handleActionRequestInternal(ActionRequest request, ActionResponse response) throws Exception {
        Post post;
        String attachmentPath = PortletRequestUtils.getRequiredStringParameter((PortletRequest)request, (String)"attachmentPath");
        String postPath = PortletRequestUtils.getRequiredStringParameter((PortletRequest)request, (String)"postPath");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Attachment path to remove: " + attachmentPath));
        }
        if ((post = this.getRepositoryDao().getPost(postPath)) != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Retrieved repository post " + post));
            }
            Iterator it = post.getAttachments().iterator();
            Attachment attachment = null;
            while (it.hasNext()) {
                attachment = (Attachment)it.next();
                if (!attachment.getPath().equals(attachmentPath)) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Found post attachment: " + attachment));
                }
                request.getPortletSession().setAttribute("attachment", (Object)attachment, 1);
                String contextPath = request.getContextPath();
                String url = contextPath + "/" + "downloadPostAttachment";
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Url is: " + url));
                }
                response.sendRedirect(url);
            }
        }
    }

    public void setRepositoryDao(RepositoryDao repositoryDao) {
        this.repositoryDao = repositoryDao;
    }
}

