/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.cms.model;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.jcrom.JcrDataProvider;
import org.jcrom.JcrDataProviderImpl;
import org.jcrom.JcrFile;
import org.jcrom.annotations.JcrNode;
import org.jcrom.annotations.JcrProperty;

@JcrNode(nodeType="nt:unstructured")
public class Attachment
extends JcrFile {
    private static final long serialVersionUID = -6710317679666037037L;
    @JcrProperty
    private String fileName;
    @JcrProperty
    private byte[] contents;
    @JcrProperty(name="jcr:mimeType")
    private String contentType;
    @JcrProperty(name="jcr:lastModified")
    private Calendar lastModified;
    @JcrProperty(name="jcr:encoding")
    private String encoding;

    public static Attachment fromFile(String fileName, String contentType, Date lastModified, Locale lc, byte[] contents) {
        Attachment attachment = new Attachment();
        attachment.setMimeType(contentType);
        Calendar c = Calendar.getInstance(lc);
        c.setTime(lastModified);
        attachment.setLastModified(c);
        attachment.setFileName(fileName);
        attachment.setContents(contents);
        return attachment;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Attachment)) {
            return false;
        }
        Attachment rhs = (Attachment)obj;
        return new EqualsBuilder().append((Object)this.getPath(), (Object)rhs.getPath()).isEquals();
    }

    public byte[] getContents() {
        return this.contents;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Calendar getLastModified() {
        return this.lastModified;
    }

    public String getMimeType() {
        return this.contentType;
    }

    public String getName() {
        if (super.getName() == null) {
            this.setName(this.getFileName());
        }
        return super.getName();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getPath()).toHashCode();
    }

    public void setContents(byte[] contents) {
        this.contents = contents;
        this.setDataProvider((JcrDataProvider)new JcrDataProviderImpl(JcrDataProvider.TYPE.BYTES, contents));
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
        this.setName(fileName);
    }

    public void setLastModified(Calendar lastModified) {
        this.lastModified = lastModified;
    }

    public void setMimeType(String mimeType) {
        this.contentType = mimeType;
    }

    public String toString() {
        ToStringBuilder bldr = new ToStringBuilder((Object)this);
        bldr.append("name", (Object)this.getName());
        bldr.append("path", (Object)this.getPath());
        bldr.append("file", (Object)this.getFileName());
        bldr.append("encoding", (Object)this.getEncoding());
        bldr.append("mimeType", (Object)this.getMimeType());
        SimpleDateFormat format = new SimpleDateFormat("MM-dd-yyyy hh:mm:ss");
        bldr.append("lastModified", (Object)format.format(this.getLastModified().getTime()));
        return bldr.toString();
    }
}

